/*
 * Decompiled with CFR 0.152.
 */
package com.worldpay.cse.jwe;

import com.worldpay.cse.exception.WPCSEException;
import com.worldpay.cse.jwe.WPEncrypter;
import java.security.Key;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.crypto.engines.AESFastEngine;
import org.spongycastle.crypto.modes.GCMBlockCipher;
import org.spongycastle.crypto.params.AEADParameters;
import org.spongycastle.crypto.params.KeyParameter;

class WPAESEncrypter
implements WPEncrypter {
    private Key key;
    private byte[] aad;
    private byte[] iv;

    public WPAESEncrypter(Key key, byte[] iv, byte[] aad) {
        this.iv = (byte[])iv.clone();
        this.key = key;
        this.aad = (byte[])aad.clone();
    }

    @Override
    public byte[] encrypt(byte[] data) {
        AEADParameters parameters = new AEADParameters(new KeyParameter(this.key.getEncoded()), 128, this.iv, this.aad);
        GCMBlockCipher gcmEngine = new GCMBlockCipher((BlockCipher)new AESFastEngine());
        gcmEngine.init(true, (CipherParameters)parameters);
        byte[] cipherText = new byte[gcmEngine.getOutputSize(data.length)];
        int encLen = gcmEngine.processBytes(data, 0, data.length, cipherText, 0);
        try {
            gcmEngine.doFinal(cipherText, encLen);
        }
        catch (InvalidCipherTextException e) {
            throw new WPCSEException(e.getLocalizedMessage(), e);
        }
        return cipherText;
    }
}

