/*
 * Decompiled with CFR 0.152.
 */
package com.worldpay.cse.jwe;

import com.worldpay.cse.exception.WPCSEException;
import com.worldpay.cse.jwe.WPAESEncrypter;
import com.worldpay.cse.jwe.WPJWEHeader;
import com.worldpay.cse.jwe.WPKeyGen;
import com.worldpay.cse.jwe.WPRSAEncrypter;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import org.spongycastle.util.encoders.UrlBase64;

public class WPJWEObject {
    private static final String ASCII = "ASCII";
    private static final String AES_ALGORITHM = "AES";
    private static final int BYTE_LENGTH = 8;
    private static final Character DOT = Character.valueOf('.');
    private WPJWEHeader header;
    private String payload;
    private byte[] encryptedKey;
    private byte[] cipherText;
    private byte[] iv;
    private byte[] authTag;
    private Key key;

    public WPJWEObject(WPJWEHeader header, String payload) {
        this.header = header;
        this.payload = payload;
    }

    public void encrypt() throws WPCSEException {
        try {
            this.iv = WPKeyGen.generateKey(96);
            byte[] aad = this.base64URLEncode(this.header.toString().getBytes()).getBytes(ASCII);
            byte[] cKey = WPKeyGen.generateKey(256);
            WPAESEncrypter cEncrypter = new WPAESEncrypter(new SecretKeySpec(cKey, AES_ALGORITHM), this.iv, aad);
            WPRSAEncrypter kEncrypter = new WPRSAEncrypter(this.key);
            this.encryptedKey = kEncrypter.encrypt(cKey);
            byte[] cipher = cEncrypter.encrypt(this.payload.getBytes());
            int tagLength = 16;
            int tagPos = cipher.length - tagLength;
            this.cipherText = new byte[tagPos];
            this.authTag = new byte[tagLength];
            System.arraycopy(cipher, 0, this.cipherText, 0, this.cipherText.length);
            System.arraycopy(cipher, tagPos, this.authTag, 0, this.authTag.length);
        }
        catch (Exception e) {
            throw new WPCSEException(e.getMessage(), e);
        }
    }

    private String base64URLEncode(byte[] bytes) throws UnsupportedEncodingException {
        String string = new String(UrlBase64.encode((byte[])bytes));
        int index = string.indexOf(DOT.charValue());
        if (index > 0) {
            string = string.substring(0, index);
        }
        return string;
    }

    public String serialize() throws WPCSEException {
        try {
            StringBuilder sb = new StringBuilder(this.base64URLEncode(this.header.toString().getBytes()));
            sb.append(DOT);
            sb.append(this.base64URLEncode(this.encryptedKey));
            sb.append(DOT);
            sb.append(this.base64URLEncode(this.iv));
            sb.append(DOT);
            sb.append(this.base64URLEncode(this.cipherText));
            sb.append(DOT);
            sb.append(this.base64URLEncode(this.authTag));
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new WPCSEException("Unsupported encoding exception", e);
        }
    }

    public void setKey(Key key) {
        this.key = key;
    }
}

