/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.parser.gson;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.worldturner.medeia.parser.JsonParserAdapter;
import com.worldturner.medeia.parser.JsonTokenData;
import com.worldturner.medeia.parser.JsonTokenDataAndLocationConsumer;
import com.worldturner.medeia.parser.JsonTokenDataKt;
import com.worldturner.medeia.parser.JsonTokenLocation;
import com.worldturner.medeia.parser.JsonTokenType;
import com.worldturner.medeia.parser.gson.GsonJsonReaderDecorator$WhenMappings;
import com.worldturner.medeia.pointer.JsonPointer;
import com.worldturner.medeia.pointer.JsonPointerBuilder;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001(B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\bH\u0016J\b\u0010#\u001a\u00020\u0014H\u0016J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\bH\u0016J\b\u0010'\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/worldturner/medeia/parser/gson/GsonJsonReaderDecorator;", "Lcom/google/gson/stream/JsonReader;", "Lcom/worldturner/medeia/parser/JsonParserAdapter;", "input", "Ljava/io/Reader;", "consumer", "Lcom/worldturner/medeia/parser/JsonTokenDataAndLocationConsumer;", "inputSourceName", "", "(Ljava/io/Reader;Lcom/worldturner/medeia/parser/JsonTokenDataAndLocationConsumer;Ljava/lang/String;)V", "dynamicTokenLocation", "Lcom/worldturner/medeia/parser/gson/GsonJsonReaderDecorator$DynamicJsonTokenLocation;", "jsonPointerBuilder", "Lcom/worldturner/medeia/pointer/JsonPointerBuilder;", "level", "", "propertyNamesStack", "Ljava/util/ArrayDeque;", "", "beginArray", "", "beginObject", "consume", "token", "Lcom/worldturner/medeia/parser/JsonTokenData;", "endArray", "endObject", "nextBoolean", "", "nextDouble", "", "nextInt", "nextLong", "", "nextName", "nextNull", "nextNumber", "", "nextString", "parseAll", "DynamicJsonTokenLocation", "medeia-validator-gson"})
public final class GsonJsonReaderDecorator
extends JsonReader
implements JsonParserAdapter {
    private final JsonPointerBuilder jsonPointerBuilder;
    private final DynamicJsonTokenLocation dynamicTokenLocation;
    private int level;
    private final ArrayDeque<Set<String>> propertyNamesStack;
    private final JsonTokenDataAndLocationConsumer consumer;
    private final String inputSourceName;

    public final void consume(@NotNull JsonTokenData token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        this.jsonPointerBuilder.consume(token, (JsonTokenLocation)this.dynamicTokenLocation);
        this.consumer.consume(token, (JsonTokenLocation)this.dynamicTokenLocation);
        switch (GsonJsonReaderDecorator$WhenMappings.$EnumSwitchMapping$0[token.getType().ordinal()]) {
            case 1: {
                this.propertyNamesStack.addFirst(new HashSet());
                break;
            }
            case 2: {
                this.propertyNamesStack.removeFirst();
                break;
            }
            case 3: {
                Collection collection = this.propertyNamesStack.peek();
                String string = token.getText();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = string;
                collection.add(string2);
            }
        }
    }

    public boolean nextBoolean() {
        boolean bl;
        boolean it = bl = super.nextBoolean();
        boolean bl2 = false;
        this.consume(it ? JsonTokenDataKt.getTOKEN_TRUE() : JsonTokenDataKt.getTOKEN_FALSE());
        return bl;
    }

    private final Number nextNumber() {
        JsonToken token = this.peek();
        if (token == JsonToken.NUMBER) {
            Number number;
            String numberAsString;
            String string = numberAsString = super.nextString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"numberAsString");
            if (StringsKt.contains$default((CharSequence)string, (char)'.', (boolean)false, (int)2, null)) {
                BigDecimal bigDecimal;
                BigDecimal it = bigDecimal = new BigDecimal(numberAsString);
                boolean bl = false;
                this.consume(new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, null, it, 14, null));
                number = bigDecimal;
            } else {
                BigInteger bigInteger;
                BigInteger it = bigInteger = new BigInteger(numberAsString);
                boolean bl = false;
                this.consume(new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, it, null, 22, null));
                number = bigInteger;
            }
            return number;
        }
        return this.nextDouble();
    }

    public int nextInt() {
        JsonToken token = this.peek();
        if (token == JsonToken.NUMBER) {
            int n;
            String numberAsString;
            String string = numberAsString = super.nextString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"numberAsString");
            if (StringsKt.contains$default((CharSequence)string, (char)'.', (boolean)false, (int)2, null)) {
                BigDecimal bigDecimal;
                BigDecimal it = bigDecimal = new BigDecimal(numberAsString);
                boolean bl = false;
                this.consume(new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, null, it, 14, null));
                n = bigDecimal.intValueExact();
            } else {
                BigInteger bigInteger;
                BigInteger it = bigInteger = new BigInteger(numberAsString);
                boolean bl = false;
                this.consume(new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, it, null, 22, null));
                n = bigInteger.intValueExact();
            }
            return n;
        }
        return this.nextInt();
    }

    public long nextLong() {
        JsonToken token = this.peek();
        if (token == JsonToken.NUMBER) {
            long l;
            String numberAsString;
            String string = numberAsString = super.nextString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"numberAsString");
            if (StringsKt.contains$default((CharSequence)string, (char)'.', (boolean)false, (int)2, null)) {
                BigDecimal bigDecimal;
                BigDecimal it = bigDecimal = new BigDecimal(numberAsString);
                boolean bl = false;
                this.consume(new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, null, it, 14, null));
                l = bigDecimal.longValueExact();
            } else {
                BigInteger bigInteger;
                BigInteger it = bigInteger = new BigInteger(numberAsString);
                boolean bl = false;
                this.consume(new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, it, null, 22, null));
                l = bigInteger.longValueExact();
            }
            return l;
        }
        return this.nextLong();
    }

    public double nextDouble() {
        JsonToken token = this.peek();
        if (token == JsonToken.NUMBER) {
            double d;
            String numberAsString;
            String string = numberAsString = super.nextString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"numberAsString");
            if (StringsKt.contains$default((CharSequence)string, (char)'.', (boolean)false, (int)2, null)) {
                BigDecimal bigDecimal;
                BigDecimal it = bigDecimal = new BigDecimal(numberAsString);
                boolean bl = false;
                this.consume(new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, null, it, 14, null));
                d = bigDecimal.doubleValue();
            } else {
                BigInteger bigInteger;
                BigInteger it = bigInteger = new BigInteger(numberAsString);
                boolean bl = false;
                this.consume(new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, it, null, 22, null));
                d = bigInteger.doubleValue();
            }
            return d;
        }
        return this.nextDouble();
    }

    @NotNull
    public String nextName() {
        String string;
        String it = string = super.nextName();
        boolean bl = false;
        this.consume(new JsonTokenData(JsonTokenType.FIELD_NAME, it, 0L, null, null, 28, null));
        String string2 = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"super.nextName().also {\n\u2026ME, text = it))\n        }");
        return string2;
    }

    @NotNull
    public String nextString() {
        JsonTokenData jsonTokenData;
        JsonTokenData it;
        Object object;
        String string;
        JsonToken token = this.peek();
        String it2 = string = super.nextString();
        boolean bl = false;
        if (token == JsonToken.NUMBER) {
            String string2 = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
            if (StringsKt.contains$default((CharSequence)string2, (char)'.', (boolean)false, (int)2, null)) {
                it = object = new BigDecimal(it2);
                boolean bl2 = false;
                jsonTokenData = new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, null, (BigDecimal)it, 14, null);
            } else {
                it = object = new BigInteger(it2);
                boolean bl3 = false;
                jsonTokenData = new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, (BigInteger)it, null, 22, null);
            }
        } else {
            String string3 = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
            jsonTokenData = JsonTokenData.Companion.createText(string3);
        }
        it = object = jsonTokenData;
        boolean bl4 = false;
        this.consume(it);
        String string4 = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"super.nextString().also \u2026{ consume(it) }\n        }");
        return string4;
    }

    public void nextNull() {
        Unit unit;
        super.nextNull();
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        this.consume(JsonTokenDataKt.getTOKEN_NULL());
    }

    public void beginArray() {
        super.beginArray();
        this.consume(JsonTokenDataKt.getTOKEN_START_ARRAY());
        int n = this.level;
        this.level = n + 1;
    }

    public void endArray() {
        super.endArray();
        int n = this.level;
        this.level = n + -1;
        this.consume(JsonTokenDataKt.getTOKEN_END_ARRAY());
    }

    public void beginObject() {
        super.beginObject();
        this.consume(JsonTokenDataKt.getTOKEN_START_OBJECT());
        int n = this.level;
        this.level = n + 1;
    }

    public void endObject() {
        super.endObject();
        int n = this.level;
        this.level = n + -1;
        this.consume(JsonTokenDataKt.getTOKEN_END_OBJECT());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parseAll() {
        while (true) {
            JsonToken token;
            if (this.peek() == null) {
                Intrinsics.throwNpe();
            }
            switch (GsonJsonReaderDecorator$WhenMappings.$EnumSwitchMapping$1[token.ordinal()]) {
                case 1: {
                    this.nextNumber();
                    break;
                }
                case 2: {
                    this.nextString();
                    break;
                }
                case 3: {
                    this.nextName();
                    break;
                }
                case 4: {
                    this.nextBoolean();
                    break;
                }
                case 5: {
                    this.nextNull();
                    break;
                }
                case 6: {
                    this.beginArray();
                    break;
                }
                case 7: {
                    this.endArray();
                    break;
                }
                case 8: {
                    this.beginObject();
                    break;
                }
                case 9: {
                    this.endObject();
                    break;
                }
                case 10: {
                    return;
                }
            }
        }
    }

    public GsonJsonReaderDecorator(@NotNull Reader input, @NotNull JsonTokenDataAndLocationConsumer consumer, @Nullable String inputSourceName) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        super(input);
        this.consumer = consumer;
        this.inputSourceName = inputSourceName;
        this.jsonPointerBuilder = new JsonPointerBuilder();
        this.dynamicTokenLocation = new DynamicJsonTokenLocation();
        this.propertyNamesStack = new ArrayDeque();
    }

    public static final /* synthetic */ void access$setLevel$p(GsonJsonReaderDecorator $this, int n) {
        $this.level = n;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0004H\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/worldturner/medeia/parser/gson/GsonJsonReaderDecorator$DynamicJsonTokenLocation;", "Lcom/worldturner/medeia/parser/JsonTokenLocation;", "(Lcom/worldturner/medeia/parser/gson/GsonJsonReaderDecorator;)V", "inputSourceName", "", "getInputSourceName", "()Ljava/lang/String;", "level", "", "getLevel", "()I", "pointer", "Lcom/worldturner/medeia/pointer/JsonPointer;", "getPointer", "()Lcom/worldturner/medeia/pointer/JsonPointer;", "propertyNames", "", "getPropertyNames", "()Ljava/util/Set;", "toString", "medeia-validator-gson"})
    public final class DynamicJsonTokenLocation
    implements JsonTokenLocation {
        @NotNull
        public JsonPointer getPointer() {
            return GsonJsonReaderDecorator.this.jsonPointerBuilder.toJsonPointer();
        }

        public int getLevel() {
            return GsonJsonReaderDecorator.this.level;
        }

        @NotNull
        public Set<String> getPropertyNames() {
            Set set = (Set)GsonJsonReaderDecorator.this.propertyNamesStack.peek();
            if (set == null) {
                set = SetsKt.emptySet();
            }
            return set;
        }

        @Nullable
        public String getInputSourceName() {
            return GsonJsonReaderDecorator.this.inputSourceName;
        }

        @NotNull
        public String toString() {
            String string;
            block3: {
                block2: {
                    String string2;
                    string = this.getInputSourceName();
                    if (string == null) break block2;
                    String it = string2 = string;
                    boolean bl = false;
                    string = "at " + this.getPointer() + " in " + this.getInputSourceName();
                    if (string != null) break block3;
                }
                string = "at " + this.getPointer();
            }
            return string;
        }

        public int getColumn() {
            return JsonTokenLocation.DefaultImpls.getColumn((JsonTokenLocation)this);
        }

        public int getLine() {
            return JsonTokenLocation.DefaultImpls.getLine((JsonTokenLocation)this);
        }
    }
}

