/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.parser.gson;

import com.google.gson.stream.JsonWriter;
import com.worldturner.medeia.parser.JsonTokenData;
import com.worldturner.medeia.parser.JsonTokenDataAndLocationConsumer;
import com.worldturner.medeia.parser.JsonTokenDataKt;
import com.worldturner.medeia.parser.JsonTokenLocation;
import com.worldturner.medeia.parser.JsonTokenType;
import com.worldturner.medeia.pointer.JsonPointer;
import com.worldturner.medeia.pointer.JsonPointerBuilder;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0002\u0010\t\n\u0002\u0010\u0004\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0001H\u0016J\b\u0010\u0016\u001a\u00020\u0001H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0001H\u0016J\b\u0010\u001c\u001a\u00020\u0001H\u0016J\u0012\u0010\u001d\u001a\u00020\u00012\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J\b\u0010 \u001a\u00020\u0001H\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020!H\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\"H\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020#H\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020$H\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/worldturner/medeia/parser/gson/GsonJsonWriterDecorator;", "Lcom/google/gson/stream/JsonWriter;", "output", "Ljava/io/Writer;", "consumer", "Lcom/worldturner/medeia/parser/JsonTokenDataAndLocationConsumer;", "inputSourceName", "", "(Ljava/io/Writer;Lcom/worldturner/medeia/parser/JsonTokenDataAndLocationConsumer;Ljava/lang/String;)V", "dynamicTokenLocation", "Lcom/worldturner/medeia/parser/gson/GsonJsonWriterDecorator$DynamicJsonTokenLocation;", "jsonPointerBuilder", "Lcom/worldturner/medeia/pointer/JsonPointerBuilder;", "<set-?>", "", "level", "getLevel", "()I", "propertyNamesStack", "Ljava/util/ArrayDeque;", "", "beginArray", "beginObject", "consume", "", "token", "Lcom/worldturner/medeia/parser/JsonTokenData;", "endArray", "endObject", "jsonValue", "value", "name", "nullValue", "", "", "", "", "DynamicJsonTokenLocation", "medeia-validator-gson"})
public final class GsonJsonWriterDecorator
extends JsonWriter {
    private int level;
    private final JsonPointerBuilder jsonPointerBuilder;
    private final DynamicJsonTokenLocation dynamicTokenLocation;
    private final ArrayDeque<Set<String>> propertyNamesStack;
    private final JsonTokenDataAndLocationConsumer consumer;
    private final String inputSourceName;

    public final int getLevel() {
        return this.level;
    }

    private final void consume(JsonTokenData token) {
        this.jsonPointerBuilder.consume(token);
        this.consumer.consume(token, (JsonTokenLocation)this.dynamicTokenLocation);
    }

    @NotNull
    public JsonWriter jsonValue(@Nullable String value) {
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public JsonWriter nullValue() {
        this.consume(JsonTokenDataKt.getTOKEN_NULL());
        JsonWriter jsonWriter = super.nullValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter, (String)"super.nullValue()");
        return jsonWriter;
    }

    @NotNull
    public JsonWriter value(boolean value) {
        this.consume(value ? JsonTokenDataKt.getTOKEN_TRUE() : JsonTokenDataKt.getTOKEN_FALSE());
        JsonWriter jsonWriter = super.value(value);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter, (String)"super.value(value)");
        return jsonWriter;
    }

    @NotNull
    public JsonWriter value(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.consume(JsonTokenData.Companion.createText(value));
        JsonWriter jsonWriter = super.value(value);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter, (String)"super.value(value)");
        return jsonWriter;
    }

    @NotNull
    public JsonWriter name(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.consume(new JsonTokenData(JsonTokenType.FIELD_NAME, name, 0L, null, null, 28, null));
        Collection collection = this.propertyNamesStack.peek();
        collection.add(name);
        JsonWriter jsonWriter = super.name(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter, (String)"super.name(name)");
        return jsonWriter;
    }

    @NotNull
    public JsonWriter value(double value) {
        JsonTokenData token = new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, null, BigDecimal.valueOf(value), 14, null);
        this.consume(token);
        JsonWriter jsonWriter = super.value(value);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter, (String)"super.value(value)");
        return jsonWriter;
    }

    @NotNull
    public JsonWriter value(long value) {
        this.consume(JsonTokenData.Companion.createNumber(value));
        JsonWriter jsonWriter = super.value(value);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter, (String)"super.value(value)");
        return jsonWriter;
    }

    @NotNull
    public JsonWriter value(@NotNull Number value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Number number = value;
        JsonTokenData token = number instanceof BigInteger ? new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, (BigInteger)value, null, 22, null) : (number instanceof BigDecimal ? new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, null, (BigDecimal)value, 14, null) : (number instanceof Integer || number instanceof AtomicInteger || number instanceof Short || number instanceof Byte ? JsonTokenData.Companion.createNumber(value.longValue()) : (number instanceof Long || number instanceof AtomicLong ? JsonTokenData.Companion.createNumber(value.longValue()) : new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, null, BigDecimal.valueOf(value.doubleValue()), 14, null))));
        this.consume(token);
        JsonWriter jsonWriter = super.value(value);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter, (String)"super.value(value)");
        return jsonWriter;
    }

    @NotNull
    public JsonWriter beginArray() {
        this.consume(JsonTokenDataKt.getTOKEN_START_ARRAY());
        int n = this.level;
        this.level = n + 1;
        super.beginArray();
        return this;
    }

    @NotNull
    public JsonWriter beginObject() {
        this.consume(JsonTokenDataKt.getTOKEN_START_OBJECT());
        this.propertyNamesStack.addFirst(new HashSet());
        int n = this.level;
        this.level = n + 1;
        super.beginObject();
        return this;
    }

    @NotNull
    public JsonWriter endArray() {
        int n = this.level;
        this.level = n + -1;
        this.consume(JsonTokenDataKt.getTOKEN_END_ARRAY());
        JsonWriter jsonWriter = super.endArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter, (String)"super.endArray()");
        return jsonWriter;
    }

    @NotNull
    public JsonWriter endObject() {
        int n = this.level;
        this.level = n + -1;
        this.consume(JsonTokenDataKt.getTOKEN_END_OBJECT());
        this.propertyNamesStack.removeFirst();
        JsonWriter jsonWriter = super.endObject();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter, (String)"super.endObject()");
        return jsonWriter;
    }

    public GsonJsonWriterDecorator(@NotNull Writer output, @NotNull JsonTokenDataAndLocationConsumer consumer, @Nullable String inputSourceName) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        super(output);
        this.consumer = consumer;
        this.inputSourceName = inputSourceName;
        this.jsonPointerBuilder = new JsonPointerBuilder();
        this.dynamicTokenLocation = new DynamicJsonTokenLocation();
        this.propertyNamesStack = new ArrayDeque();
    }

    public static final /* synthetic */ int access$getLevel$p(GsonJsonWriterDecorator $this) {
        return $this.level;
    }

    public static final /* synthetic */ void access$setLevel$p(GsonJsonWriterDecorator $this, int n) {
        $this.level = n;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0004H\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/worldturner/medeia/parser/gson/GsonJsonWriterDecorator$DynamicJsonTokenLocation;", "Lcom/worldturner/medeia/parser/JsonTokenLocation;", "(Lcom/worldturner/medeia/parser/gson/GsonJsonWriterDecorator;)V", "inputSourceName", "", "getInputSourceName", "()Ljava/lang/String;", "level", "", "getLevel", "()I", "pointer", "Lcom/worldturner/medeia/pointer/JsonPointer;", "getPointer", "()Lcom/worldturner/medeia/pointer/JsonPointer;", "propertyNames", "", "getPropertyNames", "()Ljava/util/Set;", "toString", "medeia-validator-gson"})
    public final class DynamicJsonTokenLocation
    implements JsonTokenLocation {
        public int getLevel() {
            return GsonJsonWriterDecorator.this.getLevel();
        }

        @NotNull
        public JsonPointer getPointer() {
            return GsonJsonWriterDecorator.this.jsonPointerBuilder.toJsonPointer();
        }

        @NotNull
        public Set<String> getPropertyNames() {
            Set set = (Set)GsonJsonWriterDecorator.this.propertyNamesStack.peek();
            if (set == null) {
                set = SetsKt.emptySet();
            }
            return set;
        }

        @Nullable
        public String getInputSourceName() {
            return GsonJsonWriterDecorator.this.inputSourceName;
        }

        @NotNull
        public String toString() {
            String string;
            block3: {
                block2: {
                    String string2;
                    string = this.getInputSourceName();
                    if (string == null) break block2;
                    String it = string2 = string;
                    boolean bl = false;
                    string = "at " + this.getPointer() + " in " + this.getInputSourceName();
                    if (string != null) break block3;
                }
                string = "at " + this.getPointer();
            }
            return string;
        }

        public int getColumn() {
            return JsonTokenLocation.DefaultImpls.getColumn((JsonTokenLocation)this);
        }

        public int getLine() {
            return JsonTokenLocation.DefaultImpls.getLine((JsonTokenLocation)this);
        }
    }
}

