/*
 * Decompiled with CFR 0.152.
 */
package com.github.hiteshsondhi88.libffmpeg;

import android.os.AsyncTask;
import com.github.hiteshsondhi88.libffmpeg.CommandResult;
import com.github.hiteshsondhi88.libffmpeg.FFmpegExecuteResponseHandler;
import com.github.hiteshsondhi88.libffmpeg.Log;
import com.github.hiteshsondhi88.libffmpeg.ShellCommand;
import com.github.hiteshsondhi88.libffmpeg.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeoutException;

class FFmpegExecuteAsyncTask
extends AsyncTask<Void, String, CommandResult> {
    private final String[] cmd;
    private final FFmpegExecuteResponseHandler ffmpegExecuteResponseHandler;
    private final ShellCommand shellCommand;
    private final long timeout;
    private long startTime;
    private Process process;
    private String output = "";

    FFmpegExecuteAsyncTask(String[] cmd, long timeout, FFmpegExecuteResponseHandler ffmpegExecuteResponseHandler) {
        this.cmd = cmd;
        this.timeout = timeout;
        this.ffmpegExecuteResponseHandler = ffmpegExecuteResponseHandler;
        this.shellCommand = new ShellCommand();
    }

    protected void onPreExecute() {
        this.startTime = System.currentTimeMillis();
        if (this.ffmpegExecuteResponseHandler != null) {
            this.ffmpegExecuteResponseHandler.onStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommandResult doInBackground(Void ... params) {
        try {
            this.process = this.shellCommand.run(this.cmd);
            if (this.process == null) {
                CommandResult commandResult = CommandResult.getDummyFailureResponse();
                return commandResult;
            }
            Log.d("Running publishing updates method");
            this.checkAndUpdateProcess();
            CommandResult commandResult = CommandResult.getOutputFromProcess(this.process);
            return commandResult;
        }
        catch (TimeoutException e) {
            Log.e("FFmpeg timed out", e);
            CommandResult commandResult = new CommandResult(false, e.getMessage());
            return commandResult;
        }
        catch (Exception e) {
            Log.e("Error running FFmpeg", e);
        }
        finally {
            Util.destroyProcess(this.process);
        }
        return CommandResult.getDummyFailureResponse();
    }

    protected void onProgressUpdate(String ... values) {
        if (values != null && values[0] != null && this.ffmpegExecuteResponseHandler != null) {
            this.ffmpegExecuteResponseHandler.onProgress(values[0]);
        }
    }

    protected void onPostExecute(CommandResult commandResult) {
        if (this.ffmpegExecuteResponseHandler != null) {
            this.output = this.output + commandResult.output;
            if (commandResult.success) {
                this.ffmpegExecuteResponseHandler.onSuccess(this.output);
            } else {
                this.ffmpegExecuteResponseHandler.onFailure(this.output);
            }
            this.ffmpegExecuteResponseHandler.onFinish();
        }
    }

    private void checkAndUpdateProcess() throws TimeoutException, InterruptedException {
        while (!Util.isProcessCompleted(this.process)) {
            if (Util.isProcessCompleted(this.process)) {
                return;
            }
            if (this.timeout != Long.MAX_VALUE && System.currentTimeMillis() > this.startTime + this.timeout) {
                throw new TimeoutException("FFmpeg timed out");
            }
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                while ((line = reader.readLine()) != null) {
                    if (this.isCancelled()) {
                        return;
                    }
                    this.output = this.output + line + "\n";
                    this.publishProgress(new String[]{line});
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    boolean isProcessCompleted() {
        return Util.isProcessCompleted(this.process);
    }
}

