/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe;

import com.stripe.model.Account;
import com.stripe.model.ApplicationFee;
import com.stripe.model.ApplicationFeeCollection;
import com.stripe.model.Balance;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionCollection;
import com.stripe.model.BitcoinReceiver;
import com.stripe.model.BitcoinReceiverCollection;
import com.stripe.model.Card;
import com.stripe.model.Charge;
import com.stripe.model.ChargeCollection;
import com.stripe.model.ChargeRefundCollection;
import com.stripe.model.Coupon;
import com.stripe.model.CouponCollection;
import com.stripe.model.Customer;
import com.stripe.model.CustomerCollection;
import com.stripe.model.CustomerSubscriptionCollection;
import com.stripe.model.DeletedCard;
import com.stripe.model.Event;
import com.stripe.model.EventCollection;
import com.stripe.model.FeeRefund;
import com.stripe.model.FeeRefundCollection;
import com.stripe.model.FileUpload;
import com.stripe.model.Invoice;
import com.stripe.model.InvoiceCollection;
import com.stripe.model.InvoiceLineItemCollection;
import com.stripe.model.PaymentSourceCollection;
import com.stripe.model.Plan;
import com.stripe.model.PlanCollection;
import com.stripe.model.Refund;
import com.stripe.model.Subscription;
import com.stripe.model.Token;
import com.wsl.modules.stripe.client.StripeAccountClient;
import com.wsl.modules.stripe.client.StripeApplicationFeeClient;
import com.wsl.modules.stripe.client.StripeBalanceClient;
import com.wsl.modules.stripe.client.StripeBitcoinReceiverClient;
import com.wsl.modules.stripe.client.StripeCardClient;
import com.wsl.modules.stripe.client.StripeChargeClient;
import com.wsl.modules.stripe.client.StripeCouponClient;
import com.wsl.modules.stripe.client.StripeCustomerClient;
import com.wsl.modules.stripe.client.StripeEventClient;
import com.wsl.modules.stripe.client.StripeFileUploadClient;
import com.wsl.modules.stripe.client.StripeInvoiceClient;
import com.wsl.modules.stripe.client.StripePlanClient;
import com.wsl.modules.stripe.client.StripeRefundClient;
import com.wsl.modules.stripe.client.StripeSubscriptionClient;
import com.wsl.modules.stripe.client.StripeTokenClient;
import com.wsl.modules.stripe.complextypes.BankAccount;
import com.wsl.modules.stripe.complextypes.CreateAccountParameters;
import com.wsl.modules.stripe.complextypes.CreateChargeParameters;
import com.wsl.modules.stripe.complextypes.CreateSubscriptionParameters;
import com.wsl.modules.stripe.complextypes.FilePurpose;
import com.wsl.modules.stripe.complextypes.ListAllBalanceHistoryParameters;
import com.wsl.modules.stripe.complextypes.ListAllCouponsParameters;
import com.wsl.modules.stripe.complextypes.ListAllPlansParameters;
import com.wsl.modules.stripe.complextypes.Source;
import com.wsl.modules.stripe.complextypes.TimeRange;
import com.wsl.modules.stripe.complextypes.UpdateAccountParameters;
import com.wsl.modules.stripe.complextypes.UpdateSubscriptionParameters;
import com.wsl.modules.stripe.exceptions.StripeConnectorException;
import com.wsl.modules.stripe.strategy.ConnectorConnectionStrategy;
import com.wsl.modules.stripe.utils.NullPayloadToEmptyMapTransformer;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.transport.NullPayload;

public class StripeConnector {
    ConnectorConnectionStrategy connectionStrategy;
    StripeCustomerClient customerClient = new StripeCustomerClient();
    StripePlanClient planClient = new StripePlanClient();
    StripeCouponClient couponClient = new StripeCouponClient();
    StripeBalanceClient balanceClient = new StripeBalanceClient();
    StripeCardClient cardClient = new StripeCardClient();
    StripeChargeClient chargeClient = new StripeChargeClient();
    StripeSubscriptionClient subClient = new StripeSubscriptionClient();
    StripeRefundClient refundClient = new StripeRefundClient();
    StripeInvoiceClient invoiceClient = new StripeInvoiceClient();
    StripeApplicationFeeClient feeClient = new StripeApplicationFeeClient();
    StripeAccountClient accountClient = new StripeAccountClient();
    StripeTokenClient tokenClient = new StripeTokenClient();
    StripeEventClient eventClient = new StripeEventClient();
    StripeBitcoinReceiverClient bitcoinClient = new StripeBitcoinReceiverClient();
    StripeFileUploadClient fileClient = new StripeFileUploadClient();

    public Customer createCustomer(int accountBalance, String couponCode, String description, String email, Map<String, Object> metadata) throws StripeConnectorException {
        return this.customerClient.createCustomer(accountBalance, couponCode, description, email, metadata);
    }

    public Customer retrieveCustomer(String id) throws StripeConnectorException {
        return this.customerClient.retrieveCustomer(id);
    }

    public Customer updateCustomer(String id, int accountBalance, String couponCode, String description, String email, Map<String, Object> metadata, String sourceToken) throws StripeConnectorException {
        return this.customerClient.updateCustomer(id, accountBalance, couponCode, description, email, metadata, sourceToken);
    }

    public Object deleteCustomer(String id) throws StripeConnectorException {
        return this.customerClient.deleteCustomer(id);
    }

    public CustomerCollection listAllCustomers(int limit, String startingAfter, String endingBefore) throws StripeConnectorException {
        return this.customerClient.listAllCustomers(limit, startingAfter, endingBefore);
    }

    public Plan createPlan(String id, int amount, String currency, String interval, int intervalCount, String planName, int trialPeriodDays, String statementDescriptor, Map<String, Object> metadata) throws StripeConnectorException {
        return this.planClient.createPlan(id, amount, currency, interval, intervalCount, planName, trialPeriodDays, statementDescriptor, metadata);
    }

    public Plan retrievePlan(String id) throws StripeConnectorException {
        return this.planClient.retrievePlan(id);
    }

    public Plan updatePlan(String id, String planName, String statementDescriptor, Map<String, Object> metadata) throws StripeConnectorException {
        return this.planClient.updatePlan(id, planName, statementDescriptor, metadata);
    }

    public Object deletePlan(String id) throws StripeConnectorException {
        return this.planClient.deletePlan(id);
    }

    public PlanCollection listAllPlans(ListAllPlansParameters listAllPlansParameters) throws StripeConnectorException {
        return this.planClient.listAllPlans(listAllPlansParameters.getCreatedTimestamp(), listAllPlansParameters.getCreated(), listAllPlansParameters.getEndingBefore(), listAllPlansParameters.getLimit(), listAllPlansParameters.getStartingAfter());
    }

    public Coupon createCoupon(String id, String duration, int amountOff, String currency, int durationInMonths, int maxRedemptions, int percentOff, String redeemBy, Map<String, Object> metadata) throws StripeConnectorException {
        return this.couponClient.createCoupon(id, duration, amountOff, currency, durationInMonths, maxRedemptions, percentOff, redeemBy, metadata);
    }

    public Coupon retrieveCoupon(String id) throws StripeConnectorException {
        return this.couponClient.retrieveCoupon(id);
    }

    public Coupon updateCoupon(String id, Map<String, Object> metadata) throws StripeConnectorException {
        return this.couponClient.updateCoupon(id, metadata);
    }

    public Object deleteCoupon(String id) throws StripeConnectorException {
        return this.couponClient.deleteCoupon(id);
    }

    public CouponCollection listAllCoupons(ListAllCouponsParameters listAllCouponsParameters) throws StripeConnectorException {
        return this.couponClient.listAllCoupons(listAllCouponsParameters.getCreatedTimestamp(), listAllCouponsParameters.getCreated(), listAllCouponsParameters.getEndingBefore(), listAllCouponsParameters.getLimit(), listAllCouponsParameters.getStartingAfter());
    }

    public Balance retrieveBalance() throws StripeConnectorException {
        return this.balanceClient.retrieveBalance();
    }

    public BalanceTransaction retrieveBalanceTransaction(String id) throws StripeConnectorException {
        return this.balanceClient.retrieveBalanceTransaction(id);
    }

    public BalanceTransactionCollection listAllBalanceHistory(ListAllBalanceHistoryParameters listAllBalanceHistoryParameters) throws StripeConnectorException {
        return this.balanceClient.listAllBalanceHistory(listAllBalanceHistoryParameters.getAvailableOnTimestamp(), listAllBalanceHistoryParameters.getAvailableOn(), listAllBalanceHistoryParameters.getCreatedTimestamp(), listAllBalanceHistoryParameters.getCreated(), listAllBalanceHistoryParameters.getCurrency(), listAllBalanceHistoryParameters.getEndingBefore(), listAllBalanceHistoryParameters.getLimit(), listAllBalanceHistoryParameters.getSourceId(), listAllBalanceHistoryParameters.getStartingAfter(), listAllBalanceHistoryParameters.getTransfer(), listAllBalanceHistoryParameters.getType());
    }

    public Card createCard(String ownerId, String sourceToken, Source source) throws StripeConnectorException {
        return this.cardClient.createCard(ownerId, sourceToken, source);
    }

    public Card retrieveCard(String ownerId, String id) throws StripeConnectorException {
        return this.cardClient.retrieveCard(ownerId, id);
    }

    public Card updateCard(String ownerId, String id, String addressCity, String addressCountry, String addressLine1, String addressLine2, String addressState, String addressZip, String expMonth, String expYear, Map<String, Object> metadata, String cardName) throws StripeConnectorException {
        return this.cardClient.updateCard(ownerId, id, addressCity, addressCountry, addressLine1, addressLine2, addressState, addressZip, expMonth, expYear, metadata, cardName);
    }

    public DeletedCard deleteCard(String ownerId, String id) throws StripeConnectorException {
        return this.cardClient.deleteCard(ownerId, id);
    }

    public PaymentSourceCollection listAllCustomerCards(String ownerId, String endingBefore, int limit, String startingAfter) throws StripeConnectorException {
        return this.cardClient.listAllCustomerCards(ownerId, endingBefore, limit, startingAfter);
    }

    public Charge createCharge(CreateChargeParameters createChargeParameters) throws StripeConnectorException {
        return this.chargeClient.createCharge(createChargeParameters.getAmount(), createChargeParameters.getCurrency(), createChargeParameters.getCustomerId(), createChargeParameters.getSource(), createChargeParameters.getDescription(), createChargeParameters.getMetadata(), createChargeParameters.isCapture(), createChargeParameters.getStatementDescriptor(), createChargeParameters.getReceiptEmail(), createChargeParameters.getDestination(), createChargeParameters.getApplicationFee(), createChargeParameters.getShipping());
    }

    public Charge retrieveCharge(String id) throws StripeConnectorException {
        return this.chargeClient.retrieveCharge(id);
    }

    public Charge updateCharge(String id, String description, Map<String, Object> metadata, String receiptEmail, Map<String, String> fraudDetails) throws StripeConnectorException {
        return this.chargeClient.updateCharge(id, description, metadata, receiptEmail, fraudDetails);
    }

    public Charge captureCharge(String id, int amount, int applicationFee, String statementDescriptor, String receiptEmail) throws StripeConnectorException {
        return this.chargeClient.captureCharge(id, amount, applicationFee, statementDescriptor, receiptEmail);
    }

    public ChargeCollection listAllCharges(String createdTimestamp, TimeRange created, String customer, String endingBefore, int limit, String startingAfter) throws StripeConnectorException {
        return this.chargeClient.listAllCharges(createdTimestamp, created, customer, endingBefore, limit, startingAfter);
    }

    public Subscription createSubscription(CreateSubscriptionParameters createSubscriptionParameters) throws StripeConnectorException {
        return this.subClient.createSubscription(createSubscriptionParameters.getCustomerId(), createSubscriptionParameters.getPlan(), createSubscriptionParameters.getCoupon(), createSubscriptionParameters.getTrialEnd(), createSubscriptionParameters.getSourceToken(), createSubscriptionParameters.getSource(), createSubscriptionParameters.getQuantity(), createSubscriptionParameters.getApplicationFeePercent(), createSubscriptionParameters.getTaxPercent(), createSubscriptionParameters.getMetadata());
    }

    public Subscription retrieveSubscription(String customerId, String subscriptionId) throws StripeConnectorException {
        return this.subClient.retrieveSubscription(customerId, subscriptionId);
    }

    public Subscription updateSubscription(UpdateSubscriptionParameters updateSubscriptionParameters) throws StripeConnectorException {
        return this.subClient.updateSubscription(updateSubscriptionParameters.getCustomerId(), updateSubscriptionParameters.getSubscriptionId(), updateSubscriptionParameters.getPlan(), updateSubscriptionParameters.getCoupon(), updateSubscriptionParameters.isProrate(), updateSubscriptionParameters.getTrialEnd(), updateSubscriptionParameters.getSourceToken(), updateSubscriptionParameters.getSource(), updateSubscriptionParameters.getQuantity(), updateSubscriptionParameters.getApplicationFeePercent(), updateSubscriptionParameters.getTaxPercent(), updateSubscriptionParameters.getMetadata());
    }

    public Subscription cancelSubscription(String customerId, String subscriptionId) throws StripeConnectorException {
        return this.subClient.cancelSubscription(customerId, subscriptionId);
    }

    public CustomerSubscriptionCollection listActiveSubscriptions(String customerId, String endingBefore, int limit, String startingAfter) throws StripeConnectorException {
        return this.subClient.listActiveSubscriptions(customerId, endingBefore, limit, startingAfter);
    }

    public Refund createRefund(String id, int amount, boolean refundApplicationFee, String reason, Map<String, Object> metadata) throws StripeConnectorException {
        return this.refundClient.createRefund(id, amount, refundApplicationFee, reason, metadata);
    }

    public Refund retrieveRefund(String id, String chargeId) throws StripeConnectorException {
        return this.refundClient.retrieveRefund(id, chargeId);
    }

    public Refund updateRefund(String id, String chargeId, Map<String, Object> metadata) throws StripeConnectorException {
        return this.refundClient.updateRefund(id, chargeId, metadata);
    }

    public ChargeRefundCollection listAllRefunds(String chargeId, String endingBefore, int limit, String startingAfter) throws StripeConnectorException {
        return this.refundClient.listAllRefunds(chargeId, endingBefore, limit, startingAfter);
    }

    public Invoice createInvoice(String customerId, int applicationFee, String description, Map<String, Object> metadata, String statementDescriptor, String subscription, double taxPercent) throws StripeConnectorException {
        return this.invoiceClient.createInvoice(customerId, applicationFee, description, metadata, statementDescriptor, subscription, taxPercent);
    }

    public Invoice retrieveInvoice(String id) throws StripeConnectorException {
        return this.invoiceClient.retrieveInvoice(id);
    }

    public InvoiceLineItemCollection retrieveInvoiceLineItems(String id, String customer, String endingBefore, int limit, String startingAfter, String subscription) throws StripeConnectorException {
        return this.invoiceClient.retrieveInvoiceLineItems(id, customer, endingBefore, limit, startingAfter, subscription);
    }

    public Invoice retrieveUpcomingInvoice(String customerId, String subscription) throws StripeConnectorException {
        return this.invoiceClient.retrieveUpcomingInvoice(customerId, subscription);
    }

    public Invoice updateInvoice(String invoiceId, int applicationFee, boolean closed, String description, boolean forgiven, Map<String, Object> metadata, String statementDescriptor, double taxPercent) throws StripeConnectorException {
        return this.invoiceClient.updateInvoice(invoiceId, applicationFee, closed, description, forgiven, metadata, statementDescriptor, taxPercent);
    }

    public Invoice payInvoice(String id) throws StripeConnectorException {
        return this.invoiceClient.payInvoice(id);
    }

    public InvoiceCollection retrieveAllInvoices(String customerId, String dateTimestamp, TimeRange date, String endingBefore, int limit, String startingAfter) throws StripeConnectorException {
        return this.invoiceClient.retrieveAllInvoices(customerId, dateTimestamp, date, endingBefore, limit, startingAfter);
    }

    public ApplicationFee retrieveApplicationFee(String id) throws StripeConnectorException {
        return this.feeClient.retrieveApplicationFee(id);
    }

    public ApplicationFeeCollection listAllApplicationFees(String charge, String createdTimestamp, TimeRange created, String endingBefore, int limit, String startingAfter) throws StripeConnectorException {
        return this.feeClient.listAllApplicationFees(charge, createdTimestamp, created, endingBefore, limit, startingAfter);
    }

    public Account createAccount(CreateAccountParameters createAccountParameters) throws StripeConnectorException {
        return this.accountClient.createAccount(createAccountParameters.isManaged(), createAccountParameters.getCountry(), createAccountParameters.getEmail(), createAccountParameters.getBusinessName(), createAccountParameters.getBusinessUrl(), createAccountParameters.getSupportPhone(), createAccountParameters.getBankAccount(), createAccountParameters.isDebitNegativeBalances(), createAccountParameters.getDefaultCurrency(), createAccountParameters.getLegalEntity(), createAccountParameters.getProductDescription(), createAccountParameters.getStatementDescriptor(), createAccountParameters.getTosAcceptance(), createAccountParameters.getTransferSchedule(), createAccountParameters.getMetadata());
    }

    public Account retrieveAccount(String id) throws StripeConnectorException {
        return this.accountClient.retrieveAccount(id);
    }

    public Account updateAccount(UpdateAccountParameters updateAccountParameters) throws StripeConnectorException {
        return this.accountClient.updateAccount(updateAccountParameters.getId(), updateAccountParameters.getEmail(), updateAccountParameters.getBusinessName(), updateAccountParameters.getBusinessUrl(), updateAccountParameters.getSupportPhone(), updateAccountParameters.getBankAccount(), updateAccountParameters.isDebitNegativeBalances(), updateAccountParameters.getDefaultCurrency(), updateAccountParameters.getLegalEntity(), updateAccountParameters.getProductDescription(), updateAccountParameters.getStatementDescriptor(), updateAccountParameters.getTosAcceptance(), updateAccountParameters.getTransferSchedule(), updateAccountParameters.getMetadata());
    }

    public Token createCardToken(String cardId, Source card, String customer) throws StripeConnectorException {
        return this.tokenClient.createCardToken(cardId, card, customer);
    }

    public Token createBankAccountToken(String bankAccountId, BankAccount bankAccount) throws StripeConnectorException {
        return this.tokenClient.createBankAccountToken(bankAccountId, bankAccount);
    }

    public Token retrieveToken(String id) throws StripeConnectorException {
        return this.tokenClient.retrieveToken(id);
    }

    public Event retrieveEvent(String id) throws StripeConnectorException {
        return this.eventClient.retrieveEvent(id);
    }

    public EventCollection listAllEvents(String createdTimestamp, TimeRange created, String endingBefore, int limit, String startingAfter, String type) throws StripeConnectorException {
        return this.eventClient.listAllEvents(createdTimestamp, created, endingBefore, limit, startingAfter, type);
    }

    public ApplicationFee createApplicationFeeRefund(String id, int amount) throws StripeConnectorException {
        return this.feeClient.createApplicationFeeRefund(id, amount);
    }

    public FeeRefund retrieveApplicationFeeRefund(String id, String fee) throws StripeConnectorException {
        return this.feeClient.retrieveApplicationFeeRefund(id, fee);
    }

    public FeeRefund updateApplicationFeeRefund(String id, String fee, Map<String, Object> metadata) throws StripeConnectorException {
        return this.feeClient.updateApplicationFeeRefund(id, fee, metadata);
    }

    public FeeRefundCollection listAllApplicationFeeRefunds(String id, String endingBefore, int limit, String startingAfter) throws StripeConnectorException {
        return this.feeClient.listAllApplicationFeeRefunds(id, endingBefore, limit, startingAfter);
    }

    public BitcoinReceiver createBitcoinReceiver(int amount, String currency, String email, String description, Map<String, Object> metadata, boolean refundMispayments) throws StripeConnectorException {
        return this.bitcoinClient.createBitcoinReceiver(amount, currency, email, description, metadata, refundMispayments);
    }

    public BitcoinReceiver retrieveBitcoinReceiver(String id) throws StripeConnectorException {
        return this.bitcoinClient.retrieveBitcoinReceiver(id);
    }

    public BitcoinReceiverCollection listAllBitcoinReceivers(String active, String endingBefore, String filled, int limit, String startingAfter, String uncapturedFunds) throws StripeConnectorException {
        return this.bitcoinClient.listAllBitcoinReceivers(active, endingBefore, filled, limit, startingAfter, uncapturedFunds);
    }

    public FileUpload createFileUpload(String file, FilePurpose purpose) throws StripeConnectorException {
        return this.fileClient.createFileUpload(file, purpose);
    }

    public ConnectorConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public void setConnectionStrategy(ConnectorConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public static Transformer transformerResolver(DataType source, DataType result, MuleContext muleContext) throws Exception {
        if (source.getType().equals(NullPayload.class) && result.getType().equals(Map.class)) {
            NullPayloadToEmptyMapTransformer nullPayloadToEmptyMapTransformer = new NullPayloadToEmptyMapTransformer();
            muleContext.getRegistry().applyProcessorsAndLifecycle((Object)nullPayloadToEmptyMapTransformer);
            return nullPayloadToEmptyMapTransformer;
        }
        return null;
    }
}

