/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.adapters;

import com.mulesource.licm.EnterpriseLicenseKey;
import com.mulesource.licm.LicenseKeyException;
import com.mulesource.licm.LicenseManagementFactory;
import com.mulesource.licm.LicenseManager;
import com.wsl.modules.stripe.adapters.StripeConnectorCapabilitiesAdapter;
import com.wsl.modules.stripe.adapters.StripeConnectorLifecycleInjectionAdapter;
import java.util.Calendar;
import java.util.Date;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.security.oauth.callback.ProcessCallback;

public class StripeConnectorProcessAdapter
extends StripeConnectorLifecycleInjectionAdapter
implements ProcessAdapter<StripeConnectorCapabilitiesAdapter>,
Initialisable {
    public <P> ProcessTemplate<P, StripeConnectorCapabilitiesAdapter> getProcessTemplate() {
        final StripeConnectorProcessAdapter object = this;
        return new ProcessTemplate<P, StripeConnectorCapabilitiesAdapter>(){

            public P execute(ProcessCallback<P, StripeConnectorCapabilitiesAdapter> processCallback, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
                return processCallback.process((Object)object);
            }

            public P execute(ProcessCallback<P, StripeConnectorCapabilitiesAdapter> processCallback, Filter filter, MuleMessage message) throws Exception {
                return processCallback.process((Object)object);
            }
        };
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.checkMuleLicense();
    }

    private void checkMuleLicense() {
        try {
            LicenseManager licenseManager = LicenseManagementFactory.getInstance().createLicenseManager("mule-ee");
            EnterpriseLicenseKey license = licenseManager.validate("mule-ee");
            Calendar expirationDate = Calendar.getInstance();
            if (license.getExpirationDate() != null) {
                expirationDate.setTime(license.getExpirationDate());
                if (expirationDate.after(new Date())) {
                    throw new RuntimeException("Your license has expire");
                }
            }
            if (license.isEvaluation()) {
                throw new RuntimeException("This Module does not allow Evaluation Licenses.");
            }
        }
        catch (LicenseKeyException _x) {
            throw new RuntimeException("This Module requires an Enterprise license");
        }
    }
}

