/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.client;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Account;
import com.stripe.net.RequestOptions;
import com.wsl.modules.stripe.complextypes.Acceptance;
import com.wsl.modules.stripe.complextypes.BankAccount;
import com.wsl.modules.stripe.complextypes.LegalEntity;
import com.wsl.modules.stripe.complextypes.TransferSchedule;
import com.wsl.modules.stripe.exceptions.StripeConnectorException;
import com.wsl.modules.stripe.utils.StripeClientUtils;
import java.util.HashMap;
import java.util.Map;

public class StripeAccountClient {
    public Account createAccount(boolean managed, String country, String email, String businessName, String businessUrl, String supportPhone, BankAccount bankAccount, boolean debitNegativeBalances, String defaultCurrency, LegalEntity legalEntity, String productDescription, String statementDescriptor, Acceptance tosAcceptance, TransferSchedule transferSchedule, Map<String, Object> metadata) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("managed", managed);
        params.put("country", country);
        params.put("email", email);
        params.put("business_name", businessName);
        params.put("business_url", businessUrl);
        params.put("support_phone", supportPhone);
        if (bankAccount != null) {
            params.put("bank_account", bankAccount.toDictionary());
        }
        params.put("debit_negative_balances", debitNegativeBalances);
        params.put("default_currency", defaultCurrency);
        if (legalEntity != null) {
            params.put("legal_entity", legalEntity.toDictionary());
        }
        params.put("product_description", productDescription);
        params.put("statement_descriptor", statementDescriptor);
        if (tosAcceptance != null) {
            params.put("tos_acceptance", tosAcceptance.toDictionary());
        }
        if (transferSchedule != null) {
            params.put("transfer_schedule", transferSchedule.toDictionary());
        }
        params.put("metadata", metadata);
        params = StripeClientUtils.removeOptionals(params);
        try {
            return Account.create(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not create the Account", e);
        }
    }

    public Account retrieveAccount(String id) throws StripeConnectorException {
        try {
            RequestOptions options = RequestOptions.getDefault();
            return Account.retrieve((String)id, (RequestOptions)options);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the Account", e);
        }
    }

    public Account updateAccount(String id, String email, String businessName, String businessUrl, String supportPhone, BankAccount bankAccount, boolean debitNegativeBalances, String defaultCurrency, LegalEntity legalEntity, String productDescription, String statementDescriptor, Acceptance tosAcceptance, TransferSchedule transferSchedule, Map<String, Object> metadata) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("email", email);
        params.put("business_name", businessName);
        params.put("business_url", businessUrl);
        params.put("support_phone", supportPhone);
        if (bankAccount != null) {
            params.put("bank_account", bankAccount.toDictionary());
        }
        params.put("debit_negative_balances", debitNegativeBalances);
        params.put("default_currency", defaultCurrency);
        if (legalEntity != null) {
            params.put("legal_entity", legalEntity.toDictionary());
        }
        params.put("product_description", productDescription);
        params.put("statement_descriptor", statementDescriptor);
        if (tosAcceptance != null) {
            params.put("tos_acceptance", tosAcceptance.toDictionary());
        }
        if (transferSchedule != null) {
            params.put("transfer_schedule", transferSchedule.toDictionary());
        }
        params.put("metadata", metadata);
        params = StripeClientUtils.removeOptionals(params);
        try {
            RequestOptions options = RequestOptions.getDefault();
            return Account.retrieve((String)id, (RequestOptions)options).update(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not update the Account", e);
        }
    }
}

