/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.client;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.ApplicationFee;
import com.stripe.model.ApplicationFeeCollection;
import com.stripe.model.FeeRefund;
import com.stripe.model.FeeRefundCollection;
import com.wsl.modules.stripe.complextypes.TimeRange;
import com.wsl.modules.stripe.exceptions.StripeConnectorException;
import com.wsl.modules.stripe.utils.StripeClientUtils;
import java.util.HashMap;
import java.util.Map;

public class StripeApplicationFeeClient {
    public ApplicationFee retrieveApplicationFee(String id) throws StripeConnectorException {
        try {
            return ApplicationFee.retrieve((String)id);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the Application Fee", e);
        }
    }

    public ApplicationFeeCollection listAllApplicationFees(String charge, String createdTimestamp, TimeRange created, String endingBefore, int limit, String startingAfter) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("charge", charge);
        if (createdTimestamp != null && !createdTimestamp.isEmpty()) {
            params.put("created", createdTimestamp);
        } else if (created != null) {
            params.put("created", created.toDict());
        }
        params.put("endingBefore", endingBefore);
        params.put("limit", limit);
        params.put("startingAfter", startingAfter);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            return ApplicationFee.all(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not list Application Fees", e);
        }
    }

    public ApplicationFee createApplicationFeeRefund(String id, int amount) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("amount", amount);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            return ApplicationFee.retrieve((String)id).refund(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not refund Application Fee", e);
        }
    }

    public FeeRefund retrieveApplicationFeeRefund(String id, String fee) throws StripeConnectorException {
        try {
            return ApplicationFee.retrieve((String)fee).getRefunds().retrieve(id);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve Application Fee Refund", e);
        }
    }

    public FeeRefund updateApplicationFeeRefund(String id, String fee, Map<String, Object> metadata) throws StripeConnectorException {
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        params.put("metadata", metadata);
        try {
            FeeRefund refund = ApplicationFee.retrieve((String)fee).getRefunds().retrieve(id);
            return refund.update(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not update Application Fee Refund", e);
        }
    }

    public FeeRefundCollection listAllApplicationFeeRefunds(String id, String endingBefore, int limit, String startingAfter) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("ending_before", endingBefore);
        params.put("limit", limit);
        params.put("startingAfter", startingAfter);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            return ApplicationFee.retrieve((String)id).getRefunds().all(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not list Application Fee Refunds", e);
        }
    }
}

