/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.client;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Balance;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionCollection;
import com.wsl.modules.stripe.complextypes.TimeRange;
import com.wsl.modules.stripe.exceptions.StripeConnectorException;
import com.wsl.modules.stripe.utils.StripeClientUtils;
import java.util.HashMap;
import java.util.Map;

public class StripeBalanceClient {
    public Balance retrieveBalance() throws StripeConnectorException {
        try {
            return Balance.retrieve();
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the balance", e);
        }
    }

    public BalanceTransaction retrieveBalanceTransaction(String id) throws StripeConnectorException {
        try {
            return BalanceTransaction.retrieve((String)id);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the Balance Transaction", e);
        }
    }

    public BalanceTransactionCollection listAllBalanceHistory(String availableOnTimestamp, TimeRange availableOn, String createdTimestamp, TimeRange created, String currency, String endingBefore, int limit, String sourceId, String startingAfter, String transfer, String type) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("limit", limit);
        if (availableOnTimestamp != null && !availableOnTimestamp.isEmpty()) {
            params.put("available_on", availableOnTimestamp);
        } else if (availableOn != null) {
            params.put("available_on", availableOn.toDict());
        }
        if (createdTimestamp != null && !createdTimestamp.isEmpty()) {
            params.put("created", createdTimestamp);
        } else if (created != null) {
            params.put("created", created.toDict());
        }
        params.put("currency", currency);
        params.put("ending_before", endingBefore);
        params.put("source", sourceId);
        params.put("startingAfter", startingAfter);
        params.put("transfer", transfer);
        params.put("type", type);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            return BalanceTransaction.all(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not list the balance history", e);
        }
    }
}

