/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.client;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.BitcoinReceiver;
import com.stripe.model.BitcoinReceiverCollection;
import com.wsl.modules.stripe.exceptions.StripeConnectorException;
import com.wsl.modules.stripe.utils.StripeClientUtils;
import java.util.HashMap;
import java.util.Map;

public class StripeBitcoinReceiverClient {
    public BitcoinReceiver createBitcoinReceiver(int amount, String currency, String email, String description, Map<String, Object> metadata, boolean refundMispayments) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("amount", amount);
        params.put("currency", currency);
        params.put("email", email);
        params.put("description", description);
        params.put("metadata", metadata);
        params.put("refund_mispayments", refundMispayments);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            return BitcoinReceiver.create(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not create Bitcoin Receiver", e);
        }
    }

    public BitcoinReceiver retrieveBitcoinReceiver(String id) throws StripeConnectorException {
        try {
            return BitcoinReceiver.retrieve((String)id);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve Bitcoin Receiver", e);
        }
    }

    public BitcoinReceiverCollection listAllBitcoinReceivers(String active, String endingBefore, String filled, int limit, String startingAfter, String uncapturedFunds) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("active", active);
        params.put("ending_before", endingBefore);
        params.put("filled", filled);
        params.put("limit", limit);
        params.put("startingAfter", startingAfter);
        params.put("uncapturedFunds", uncapturedFunds);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            return BitcoinReceiver.all(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not list Bitcoin Receivers", e);
        }
    }
}

