/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.client;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Card;
import com.stripe.model.Customer;
import com.stripe.model.DeletedCard;
import com.stripe.model.PaymentSource;
import com.stripe.model.PaymentSourceCollection;
import com.wsl.modules.stripe.complextypes.Source;
import com.wsl.modules.stripe.exceptions.StripeConnectorException;
import com.wsl.modules.stripe.utils.StripeClientUtils;
import java.util.HashMap;
import java.util.Map;

public class StripeCardClient {
    public Card createCard(String ownerId, String sourceToken, Source source) throws StripeConnectorException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (sourceToken != null && !sourceToken.isEmpty()) {
            params.put("source", sourceToken);
        } else if (source != null) {
            Map<String, Object> sourceDict = source.toDictionary();
            sourceDict = StripeClientUtils.removeOptionals(sourceDict);
            params.put("source", sourceDict);
        }
        try {
            Customer customer = Customer.retrieve((String)ownerId);
            return customer.createCard(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not create the Card", e);
        }
    }

    public Card retrieveCard(String ownerId, String id) throws StripeConnectorException {
        try {
            Customer customer = Customer.retrieve((String)ownerId);
            PaymentSource source = customer.getSources().retrieve(id);
            if (source.getObject().equals("card")) {
                return (Card)source;
            }
            throw new CardException("The source was not a card", "001", id, (Throwable)new Exception("Source was not a card type"));
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the Card", e);
        }
    }

    public Card updateCard(String ownerId, String id, String addressCity, String addressCountry, String addressLine1, String addressLine2, String addressState, String addressZip, String expMonth, String expYear, Map<String, Object> metadata, String cardName) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("address_city", addressCity);
        params.put("address_country", addressCountry);
        params.put("address_line1", addressLine1);
        params.put("address_line2", addressLine2);
        params.put("address_state", addressState);
        params.put("address_zip", addressZip);
        params.put("exp_month", expMonth);
        params.put("exp_year", expYear);
        params.put("metadata", metadata);
        params.put("name", cardName);
        params = StripeClientUtils.removeOptionals(params);
        try {
            Customer customer = Customer.retrieve((String)ownerId);
            PaymentSource source = customer.getSources().retrieve(id);
            return (Card)source.update(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not update the Card", e);
        }
    }

    public DeletedCard deleteCard(String ownerId, String id) throws StripeConnectorException {
        try {
            Customer customer = Customer.retrieve((String)ownerId);
            for (PaymentSource source : customer.getSources().getData()) {
                if (!source.getId().equals(id)) continue;
                return (DeletedCard)source.delete();
            }
            throw new CardException("The card wasn't found", "001", id, (Throwable)new Exception("Card id was not found"));
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not delete the Card", e);
        }
    }

    public PaymentSourceCollection listAllCustomerCards(String ownerId, String endingBefore, int limit, String startingAfter) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("limit", limit);
        params.put("ending_before", endingBefore);
        params.put("startingAfter", startingAfter);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            Customer customer = Customer.retrieve((String)ownerId);
            return customer.getSources().all(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not list the customer cards", e);
        }
    }
}

