/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.client;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Charge;
import com.stripe.model.ChargeCollection;
import com.wsl.modules.stripe.complextypes.Source;
import com.wsl.modules.stripe.complextypes.TimeRange;
import com.wsl.modules.stripe.exceptions.StripeConnectorException;
import com.wsl.modules.stripe.utils.StripeClientUtils;
import java.util.HashMap;
import java.util.Map;

public class StripeChargeClient {
    public Charge createCharge(int amount, String currency, String customerId, Source source, String description, Map<String, Object> metadata, boolean capture, String statementDescriptor, String receiptEmail, String destination, int applicationFee, Map<String, String> shipping) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        if (source != null) {
            Map<String, Object> sourceDict = source.toDictionary();
            sourceDict = StripeClientUtils.removeOptionals(sourceDict);
            params.put("source", sourceDict);
        }
        params.put("amount", amount);
        params.put("currency", currency);
        params.put("customer", customerId);
        params.put("description", description);
        params.put("metadata", metadata);
        params.put("capture", capture);
        params.put("statement_descriptor", statementDescriptor);
        params.put("receipt_email", receiptEmail);
        params.put("destination", destination);
        params.put("application_fee", applicationFee);
        params.put("shipping", shipping);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            return Charge.create(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not create the Charge", e);
        }
    }

    public Charge retrieveCharge(String id) throws StripeConnectorException {
        try {
            return Charge.retrieve((String)id);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the Charge", e);
        }
    }

    public Charge updateCharge(String id, String description, Map<String, Object> metadata, String receiptEmail, Map<String, String> fraudDetails) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("description", description);
        params.put("metadata", metadata);
        params.put("receipt_email", receiptEmail);
        params.put("fraud_details", fraudDetails);
        params = StripeClientUtils.removeOptionals(params);
        try {
            Charge charge = Charge.retrieve((String)id);
            return charge.update(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not update the Charge", e);
        }
    }

    public Charge captureCharge(String id, int amount, int applicationFee, String statementDescriptor, String receiptEmail) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("amount", amount);
        params.put("statement_descriptor", statementDescriptor);
        params.put("receipt_email", receiptEmail);
        params.put("application_fee", applicationFee);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            Charge charge = Charge.retrieve((String)id);
            return charge.capture(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not capture the Charge", e);
        }
    }

    public ChargeCollection listAllCharges(String createdTimestamp, TimeRange created, String customer, String endingBefore, int limit, String startingAfter) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("limit", limit);
        params.put("ending_before", endingBefore);
        params.put("startingAfter", startingAfter);
        params.put("customer", customer);
        if (createdTimestamp != null && !createdTimestamp.isEmpty()) {
            params.put("created", createdTimestamp);
        } else if (created != null) {
            params.put("created", created.toDict());
        }
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            return Charge.all(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not list the charges", e);
        }
    }
}

