/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.client;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Coupon;
import com.stripe.model.CouponCollection;
import com.wsl.modules.stripe.complextypes.TimeRange;
import com.wsl.modules.stripe.exceptions.StripeConnectorException;
import com.wsl.modules.stripe.utils.StripeClientUtils;
import java.util.HashMap;
import java.util.Map;

public class StripeCouponClient {
    public Coupon createCoupon(String id, String duration, int amountOff, String currency, int durationInMonths, int maxRedemptions, int percentOff, String redeemBy, Map<String, Object> metadata) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("duration", duration);
        params.put("amount_off", amountOff);
        params.put("currency", currency);
        params.put("duration_in_months", durationInMonths);
        params.put("max_redemptions", maxRedemptions);
        params.put("metadata", metadata);
        params.put("percent_off", percentOff);
        params.put("redeem_by", redeemBy);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            return Coupon.create(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not create the coupon", e);
        }
    }

    public Coupon retrieveCoupon(String id) throws StripeConnectorException {
        try {
            return Coupon.retrieve((String)id);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the coupon", e);
        }
    }

    public Coupon updateCoupon(String id, Map<String, Object> metadata) throws StripeConnectorException {
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        params.put("metadata", metadata);
        try {
            Coupon coupon = Coupon.retrieve((String)id);
            return coupon.update(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not update the coupon", e);
        }
    }

    public Object deleteCoupon(String id) throws StripeConnectorException {
        try {
            Coupon coupon = Coupon.retrieve((String)id);
            return coupon.delete();
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not delete the coupon", e);
        }
    }

    public CouponCollection listAllCoupons(String createdTimestamp, TimeRange created, String endingBefore, int limit, String startingAfter) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        if (limit != 0) {
            params.put("limit", limit);
        }
        if (createdTimestamp != null && !createdTimestamp.isEmpty()) {
            params.put("created", createdTimestamp);
        } else if (created != null) {
            params.put("created", created.toDict());
        }
        params.put("ending_before", endingBefore);
        params.put("starting_after", startingAfter);
        params = StripeClientUtils.removeOptionals(params);
        try {
            return Coupon.all(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not list coupons", e);
        }
    }
}

