/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.client;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Customer;
import com.stripe.model.CustomerCollection;
import com.wsl.modules.stripe.exceptions.StripeConnectorException;
import com.wsl.modules.stripe.utils.StripeClientUtils;
import java.util.HashMap;
import java.util.Map;

public class StripeCustomerClient {
    public Customer createCustomer(int accountBalance, String couponCode, String description, String email, Map<String, Object> metadata) throws StripeConnectorException {
        Map<String, Object> customerParams = new HashMap<String, Object>();
        if (accountBalance > 0) {
            customerParams.put("account_balance", accountBalance);
        }
        customerParams.put("coupon", couponCode);
        customerParams.put("description", description);
        customerParams.put("email", email);
        customerParams.put("metadata", metadata);
        customerParams = StripeClientUtils.removeOptionals(customerParams);
        try {
            return Customer.create(customerParams);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not create a customer", e);
        }
    }

    public Customer retrieveCustomer(String id) throws StripeConnectorException {
        try {
            return Customer.retrieve((String)id);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the customer", e);
        }
    }

    public Customer updateCustomer(String id, int accountBalance, String couponCode, String description, String email, Map<String, Object> metadata, String sourceToken) throws StripeConnectorException {
        Map<String, Object> customerParams = new HashMap<String, Object>();
        if (accountBalance > 0) {
            customerParams.put("account_balance", accountBalance);
        }
        customerParams.put("coupon", couponCode);
        customerParams.put("description", description);
        customerParams.put("email", email);
        customerParams.put("metadata", metadata);
        customerParams.put("source", sourceToken);
        customerParams = StripeClientUtils.removeOptionals(customerParams);
        try {
            Customer cust = this.retrieveCustomer(id);
            return cust.update(customerParams);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not update the customer", e);
        }
    }

    public Object deleteCustomer(String id) throws StripeConnectorException {
        try {
            Customer cust = Customer.retrieve((String)id);
            return cust.delete();
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not delete the customer", e);
        }
    }

    public CustomerCollection listAllCustomers(int limit, String startingAfter, String endingBefore) throws StripeConnectorException {
        Map<String, Object> customerParams = new HashMap<String, Object>();
        if (limit > 0) {
            customerParams.put("limit", limit);
        }
        customerParams.put("starting_after", startingAfter);
        customerParams.put("ending_before", endingBefore);
        customerParams = StripeClientUtils.removeOptionals(customerParams);
        try {
            return Customer.all(customerParams);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not create a customer", e);
        }
    }
}

