/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.client;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Event;
import com.stripe.model.EventCollection;
import com.wsl.modules.stripe.complextypes.TimeRange;
import com.wsl.modules.stripe.exceptions.StripeConnectorException;
import com.wsl.modules.stripe.utils.StripeClientUtils;
import java.util.HashMap;
import java.util.Map;

public class StripeEventClient {
    public Event retrieveEvent(String id) throws StripeConnectorException {
        try {
            return Event.retrieve((String)id);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the Event", e);
        }
    }

    public EventCollection listAllEvents(String createdTimestamp, TimeRange created, String endingBefore, int limit, String startingAfter, String type) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        if (createdTimestamp != null && !createdTimestamp.isEmpty()) {
            params.put("created", createdTimestamp);
        } else if (created != null) {
            params.put("created", created.toDict());
        }
        params.put("ending_before", endingBefore);
        params.put("limit", limit);
        params.put("startingAfter", startingAfter);
        params.put("type", type);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            return Event.all(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not list Events", e);
        }
    }
}

