/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.client;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.FileUpload;
import com.wsl.modules.stripe.complextypes.FilePurpose;
import com.wsl.modules.stripe.exceptions.StripeConnectorException;
import java.io.File;
import java.util.HashMap;

public class StripeFileUploadClient {
    public FileUpload createFileUpload(String file, FilePurpose purpose) throws StripeConnectorException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("file", new File(file));
        params.put("purpose", purpose.toString());
        try {
            return FileUpload.create(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not create the File Upload", e);
        }
    }
}

