/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.client;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Invoice;
import com.stripe.model.InvoiceCollection;
import com.stripe.model.InvoiceLineItemCollection;
import com.wsl.modules.stripe.complextypes.TimeRange;
import com.wsl.modules.stripe.exceptions.StripeConnectorException;
import com.wsl.modules.stripe.utils.StripeClientUtils;
import java.util.HashMap;
import java.util.Map;

public class StripeInvoiceClient {
    public Invoice createInvoice(String customerId, int applicationFee, String description, Map<String, Object> metadata, String statementDescriptor, String subscription, double taxPercent) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("customer", customerId);
        params.put("application_fee", applicationFee);
        params.put("description", description);
        params.put("metadata", metadata);
        params.put("statement_descriptor", statementDescriptor);
        params.put("subscription", subscription);
        params.put("tax_percent", taxPercent);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            return Invoice.create(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not create the Invoice", e);
        }
    }

    public Invoice retrieveInvoice(String id) throws StripeConnectorException {
        try {
            return Invoice.retrieve((String)id);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the Invoice", e);
        }
    }

    public InvoiceLineItemCollection retrieveInvoiceLineItems(String id, String customer, String endingBefore, int limit, String startingAfter, String subscription) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("customer", customer);
        params.put("endingBefore", endingBefore);
        params.put("limit", limit);
        params.put("startingAfter", startingAfter);
        params.put("subscription", subscription);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            Invoice invoice = Invoice.retrieve((String)id);
            return invoice.getLines().all(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the Invoice Line Items", e);
        }
    }

    public Invoice retrieveUpcomingInvoice(String customerId, String subscription) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("customer", customerId);
        params.put("subscription", subscription);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            return Invoice.upcoming(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the upcoming Invoice", e);
        }
    }

    public Invoice updateInvoice(String invoiceId, int applicationFee, boolean closed, String description, boolean forgiven, Map<String, Object> metadata, String statementDescriptor, double taxPercent) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("application_fee", applicationFee);
        params.put("closed", closed);
        params.put("description", description);
        params.put("forgiven", forgiven);
        params.put("metadata", metadata);
        params.put("statement_descriptor", statementDescriptor);
        params.put("tax_percent", taxPercent);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            Invoice invoice = Invoice.retrieve((String)invoiceId);
            return invoice.update(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not update the Invoice", e);
        }
    }

    public Invoice payInvoice(String id) throws StripeConnectorException {
        try {
            Invoice invoice = Invoice.retrieve((String)id);
            return invoice.pay();
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not pay the Invoice", e);
        }
    }

    public InvoiceCollection retrieveAllInvoices(String customerId, String dateTimestamp, TimeRange date, String endingBefore, int limit, String startingAfter) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("customer", customerId);
        if (dateTimestamp != null && !dateTimestamp.isEmpty()) {
            params.put("date", dateTimestamp);
        } else if (date != null) {
            params.put("date", date.toDict());
        }
        params.put("endingBefore", endingBefore);
        params.put("limit", limit);
        params.put("startingAfter", startingAfter);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            return Invoice.all(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve Invoices", e);
        }
    }
}

