/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.client;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Plan;
import com.stripe.model.PlanCollection;
import com.wsl.modules.stripe.complextypes.TimeRange;
import com.wsl.modules.stripe.exceptions.StripeConnectorException;
import com.wsl.modules.stripe.utils.StripeClientUtils;
import java.util.HashMap;
import java.util.Map;

public class StripePlanClient {
    public Plan createPlan(String id, int amount, String currency, String interval, int intervalCount, String planName, int trialPeriodDays, String statementDescriptor, Map<String, Object> metadata) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        if (trialPeriodDays > 0) {
            params.put("trial_period_days", trialPeriodDays);
        }
        params.put("id", id);
        params.put("amount", amount);
        params.put("currency", currency);
        params.put("interval", interval);
        params.put("interval_count", intervalCount);
        params.put("name", planName);
        params.put("statement_descriptor", statementDescriptor);
        params.put("metadata", metadata);
        params = StripeClientUtils.removeOptionals(params);
        try {
            return Plan.create(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not create a plan", e);
        }
    }

    public Plan retrievePlan(String id) throws StripeConnectorException {
        try {
            return Plan.retrieve((String)id);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the plan", e);
        }
    }

    public Plan updatePlan(String id, String planName, String statementDescriptor, Map<String, Object> metadata) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("name", planName);
        params.put("statement_descriptor", statementDescriptor);
        params.put("metadata", metadata);
        params = StripeClientUtils.removeOptionals(params);
        try {
            Plan plan = Plan.retrieve((String)id);
            return plan.update(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not create a plan", e);
        }
    }

    public Object deletePlan(String id) throws StripeConnectorException {
        try {
            Plan plan = Plan.retrieve((String)id);
            return plan.delete();
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the plan", e);
        }
    }

    public PlanCollection listAllPlans(String createdTimestamp, TimeRange created, String endingBefore, int limit, String startingAfter) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        if (limit > 0) {
            params.put("limit", limit);
        }
        if (createdTimestamp != null) {
            params.put("created", createdTimestamp);
        } else if (created != null) {
            params.put("created", created.toDict());
        }
        params.put("ending_before", endingBefore);
        params.put("starting_after", startingAfter);
        params = StripeClientUtils.removeOptionals(params);
        try {
            return Plan.all(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not list plans", e);
        }
    }
}

