/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.client;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Charge;
import com.stripe.model.ChargeRefundCollection;
import com.stripe.model.Refund;
import com.wsl.modules.stripe.exceptions.StripeConnectorException;
import com.wsl.modules.stripe.utils.StripeClientUtils;
import java.util.HashMap;
import java.util.Map;

public class StripeRefundClient {
    public Refund createRefund(String id, int amount, boolean refundApplicationFee, String reason, Map<String, Object> metadata) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("amount", amount);
        params.put("refund_application_fee", refundApplicationFee);
        params.put("reason", reason);
        params.put("metadata", metadata);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            Charge charge = Charge.retrieve((String)id);
            return charge.getRefunds().create(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not create the Refund", e);
        }
    }

    public Refund retrieveRefund(String id, String chargeId) throws StripeConnectorException {
        try {
            Charge charge = Charge.retrieve((String)chargeId);
            return charge.getRefunds().retrieve(id);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the Refund", e);
        }
    }

    public Refund updateRefund(String id, String chargeId, Map<String, Object> metadata) throws StripeConnectorException {
        try {
            HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
            params.put("metadata", metadata);
            Charge charge = Charge.retrieve((String)chargeId);
            Refund refund = charge.getRefunds().retrieve(id);
            return refund.update(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not update the Refund", e);
        }
    }

    public ChargeRefundCollection listAllRefunds(String chargeId, String endingBefore, int limit, String startingAfter) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("limit", limit);
        params.put("ending_before", endingBefore);
        params.put("startingAfter", startingAfter);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            Charge charge = Charge.retrieve((String)chargeId);
            return charge.getRefunds().all(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not list the Refunds", e);
        }
    }
}

