/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.client;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Customer;
import com.stripe.model.CustomerSubscriptionCollection;
import com.stripe.model.Subscription;
import com.wsl.modules.stripe.complextypes.Source;
import com.wsl.modules.stripe.exceptions.StripeConnectorException;
import com.wsl.modules.stripe.utils.StripeClientUtils;
import java.util.HashMap;
import java.util.Map;

public class StripeSubscriptionClient {
    public Subscription createSubscription(String customerId, String plan, String coupon, String trialEnd, String sourceToken, Source source, int quantity, double applicationFeePercent, double taxPercent, Map<String, Object> metadata) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("plan", plan);
        params.put("coupon", coupon);
        params.put("trial_end", trialEnd);
        if (sourceToken != null && !sourceToken.isEmpty()) {
            params.put("source", sourceToken);
        } else if (source != null) {
            params.put("source", StripeClientUtils.removeOptionals(source.toDictionary()));
        }
        params.put("quantity", quantity);
        params.put("application_fee_percent", applicationFeePercent);
        params.put("tax_percent", taxPercent);
        params.put("metadata", metadata);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            Customer customer = Customer.retrieve((String)customerId);
            return customer.createSubscription(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not create the Subscription", e);
        }
    }

    public Subscription retrieveSubscription(String customerId, String subscriptionId) throws StripeConnectorException {
        try {
            Customer customer = Customer.retrieve((String)customerId);
            return customer.getSubscriptions().retrieve(subscriptionId);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the Subscription", e);
        }
    }

    public Subscription updateSubscription(String customerId, String subscriptionId, String plan, String coupon, boolean prorate, String trialEnd, String sourceToken, Source source, int quantity, double applicationFeePercent, double taxPercent, Map<String, Object> metadata) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("plan", plan);
        params.put("coupon", coupon);
        params.put("prorate", prorate);
        params.put("trial_end", trialEnd);
        if (sourceToken != null && !sourceToken.isEmpty()) {
            params.put("source", sourceToken);
        } else if (source != null) {
            params.put("source", StripeClientUtils.removeOptionals(source.toDictionary()));
        }
        params.put("quantity", quantity);
        params.put("application_fee_percent", applicationFeePercent);
        params.put("tax_percent", taxPercent);
        params.put("metadata", metadata);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            Customer customer = Customer.retrieve((String)customerId);
            return customer.getSubscriptions().retrieve(subscriptionId).update(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not update the Subscription", e);
        }
    }

    public Subscription cancelSubscription(String customerId, String subscriptionId) throws StripeConnectorException {
        try {
            Customer customer = Customer.retrieve((String)customerId);
            for (Subscription subscription : customer.getSubscriptions().getData()) {
                if (!subscription.getId().equals(subscriptionId)) continue;
                return subscription.cancel(null);
            }
            throw new APIException("Could not find subscription to cancel", (Throwable)new Exception("Subscription was not found"));
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not cancel the Subscription", e);
        }
    }

    public CustomerSubscriptionCollection listActiveSubscriptions(String customerId, String endingBefore, int limit, String startingAfter) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("limit", limit);
        params.put("ending_before", endingBefore);
        params.put("startingAfter", startingAfter);
        params = StripeClientUtils.removeOptionalsAndZeroes(params);
        try {
            Customer customer = Customer.retrieve((String)customerId);
            return customer.getSubscriptions().all(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not list the Subscriptions", e);
        }
    }
}

