/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.client;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Token;
import com.wsl.modules.stripe.complextypes.BankAccount;
import com.wsl.modules.stripe.complextypes.Source;
import com.wsl.modules.stripe.exceptions.StripeConnectorException;
import com.wsl.modules.stripe.utils.StripeClientUtils;
import java.util.HashMap;
import java.util.Map;

public class StripeTokenClient {
    public Token createCardToken(String cardId, Source card, String customer) throws StripeConnectorException {
        Map<String, Object> params = new HashMap<String, Object>();
        if (cardId != null && !cardId.isEmpty()) {
            params.put("card", cardId);
        } else if (card != null) {
            params.put("card", card.toDictionary());
        }
        params.put("customer", customer);
        params = StripeClientUtils.removeOptionals(params);
        try {
            return Token.create(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not create a Card Token", e);
        }
    }

    public Token createBankAccountToken(String bankAccountId, BankAccount bankAccount) throws StripeConnectorException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (bankAccountId != null && !bankAccountId.isEmpty()) {
            params.put("bank_account", bankAccountId);
        } else if (bankAccount != null) {
            params.put("bank_account", bankAccount.toDictionary());
        }
        try {
            return Token.create(params);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not create a Bank Account Token", e);
        }
    }

    public Token retrieveToken(String id) throws StripeConnectorException {
        try {
            return Token.retrieve((String)id);
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            throw new StripeConnectorException("Could not retrieve the Token", e);
        }
    }
}

