/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.connectivity;

import com.wsl.modules.stripe.adapters.StripeConnectorConnectionManagementAdapter;
import com.wsl.modules.stripe.connectivity.ConnectionManagementConfigTypeStripeConnectorConnectionKey;
import com.wsl.modules.stripe.connectivity.ConnectorConnectionStrategyStripeConnectorAdapter;
import com.wsl.modules.stripe.pooling.DevkitGenericKeyedObjectPool;
import com.wsl.modules.stripe.strategy.ConnectorConnectionStrategy;
import org.apache.commons.pool.KeyedObjectPool;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.devkit.capability.ModuleCapability;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultTestResult;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.config.PoolingProfile;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectionAdapter;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectionManager;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectorAdapter;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectorFactory;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementProcessTemplate;
import org.mule.devkit.3.6.1.shade.connection.management.UnableToAcquireConnectionException;
import org.mule.devkit.3.6.1.shade.connectivity.ConnectivityTestingErrorHandler;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;

public class StripeConnectorConfigTypeConnectionManagementConnectionManager
extends ExpressionEvaluatorSupport
implements MetadataAware,
MuleContextAware,
ProcessAdapter<StripeConnectorConnectionManagementAdapter>,
Capabilities,
Disposable,
Initialisable,
Testable,
ConnectionManagementConnectionManager<ConnectionManagementConfigTypeStripeConnectorConnectionKey, StripeConnectorConnectionManagementAdapter, ConnectorConnectionStrategy> {
    private String apiKey;
    private String apiVersion;
    protected MuleContext muleContext;
    private KeyedObjectPool connectionPool;
    protected PoolingProfile poolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "Stripe";
    private static final String MODULE_VERSION = "1.0.3";
    private static final String DEVKIT_VERSION = "3.6.1";
    private static final String DEVKIT_BUILD = "UNNAMED.2405.44720b7";
    private static final String MIN_MULE_VERSION = "3.6";

    public void setApiKey(String value) {
        this.apiKey = value;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiVersion(String value) {
        this.apiVersion = value;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setPoolingProfile(PoolingProfile value) {
        this.poolingProfile = value;
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void initialise() {
        this.connectionPool = new DevkitGenericKeyedObjectPool(new ConnectionManagementConnectorFactory(this), this.poolingProfile);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public void dispose() {
        try {
            this.connectionPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public StripeConnectorConnectionManagementAdapter acquireConnection(ConnectionManagementConfigTypeStripeConnectorConnectionKey key) throws Exception {
        return (StripeConnectorConnectionManagementAdapter)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(ConnectionManagementConfigTypeStripeConnectorConnectionKey key, StripeConnectorConnectionManagementAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(ConnectionManagementConfigTypeStripeConnectorConnectionKey key, StripeConnectorConnectionManagementAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    public boolean isCapableOf(ModuleCapability capability) {
        if (capability == ModuleCapability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == ModuleCapability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    public <P> ProcessTemplate<P, StripeConnectorConnectionManagementAdapter> getProcessTemplate() {
        return new ConnectionManagementProcessTemplate(this, this.muleContext);
    }

    @Override
    public ConnectionManagementConfigTypeStripeConnectorConnectionKey getDefaultConnectionKey() {
        return new ConnectionManagementConfigTypeStripeConnectorConnectionKey(this.getApiKey());
    }

    @Override
    public ConnectionManagementConfigTypeStripeConnectorConnectionKey getEvaluatedConnectionKey(MuleEvent event) throws Exception {
        if (event != null) {
            String _transformedApiKey = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("apiKey").getGenericType(), null, this.getApiKey());
            if (_transformedApiKey == null) {
                throw new UnableToAcquireConnectionException("Parameter apiKey in method connect can't be null because is not @Optional");
            }
            return new ConnectionManagementConfigTypeStripeConnectorConnectionKey(_transformedApiKey);
        }
        return this.getDefaultConnectionKey();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    public String getMinMuleVersion() {
        return MIN_MULE_VERSION;
    }

    @Override
    public ConnectionManagementConfigTypeStripeConnectorConnectionKey getConnectionKey(MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        return this.getEvaluatedConnectionKey(event);
    }

    @Override
    public ConnectionManagementConnectionAdapter newConnection() {
        ConnectorConnectionStrategyStripeConnectorAdapter connection = new ConnectorConnectionStrategyStripeConnectorAdapter();
        connection.setApiVersion(this.getApiVersion());
        return connection;
    }

    @Override
    public ConnectionManagementConnectorAdapter newConnector(ConnectionManagementConnectionAdapter<ConnectorConnectionStrategy, ConnectionManagementConfigTypeStripeConnectorConnectionKey> connection) {
        StripeConnectorConnectionManagementAdapter connector = new StripeConnectorConnectionManagementAdapter();
        connector.setConnectionStrategy(connection.getStrategy());
        return connector;
    }

    @Override
    public ConnectionManagementConnectionAdapter getConnectionAdapter(ConnectionManagementConnectorAdapter adapter) {
        StripeConnectorConnectionManagementAdapter connector = (StripeConnectorConnectionManagementAdapter)adapter;
        ConnectionManagementConnectionAdapter strategy = (ConnectionManagementConnectionAdapter)((Object)connector.getConnectionStrategy());
        return strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test() {
        DefaultTestResult result;
        StripeConnectorConnectionManagementAdapter connection = null;
        ConnectionManagementConfigTypeStripeConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            result = new DefaultTestResult(Result.Status.SUCCESS);
        }
        catch (Exception e) {
            try {
                this.destroyConnection(key, connection);
            }
            catch (Exception ie) {
                // empty catch block
            }
            result = (DefaultTestResult)ConnectivityTestingErrorHandler.buildFailureTestResult(e);
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
        return result;
    }
}

