/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.strategy;

import com.stripe.Stripe;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Balance;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorConnectionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorConnectionStrategy.class);
    private String apiVersion;

    private static void staticSetApiKey(String apiKey) {
        Stripe.apiKey = apiKey;
    }

    private static void staticSetApiVersion(String apiVersion) {
        Stripe.apiVersion = apiVersion;
    }

    public void connect(String apiKey) throws ConnectionException {
        ConnectorConnectionStrategy.staticSetApiKey(apiKey);
        ConnectorConnectionStrategy.staticSetApiVersion(this.apiVersion);
        try {
            Balance.retrieve();
        }
        catch (APIConnectionException | APIException | AuthenticationException | CardException | InvalidRequestException e) {
            LOGGER.error("Error connecting to Stripe", e);
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, e.getMessage(), "Unable to Connect to Stripe");
        }
    }

    public void disconnect() {
        ConnectorConnectionStrategy.staticSetApiKey(null);
    }

    public boolean isConnected() {
        return Stripe.apiKey != null;
    }

    public String connectionId() {
        return "1.27.1";
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }
}

