/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.stripe.transformerResolvers;

import com.wsl.modules.stripe.StripeConnector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.config.i18n.CoreMessages;

public class TransformerResolverTransformerResolver
implements MuleContextAware,
Disposable,
TransformerResolver {
    private MuleContext muleContext;
    private Map<String, Transformer> transformerCache = new ConcurrentHashMap<String, Transformer>();

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void transformerChange(Transformer transformer, TransformerResolver.RegistryAction registryAction) {
    }

    public void dispose() {
        this.transformerCache.clear();
    }

    public Transformer resolve(DataType<?> source, DataType<?> result) throws ResolverException {
        Transformer t = this.transformerCache.get(source.toString().concat(result.toString()));
        if (t != null) {
            return t;
        }
        try {
            t = StripeConnector.transformerResolver(source, result, this.muleContext);
        }
        catch (Exception e) {
            throw new ResolverException(CoreMessages.createStaticMessage((String)"Error resolving transformer."), (Throwable)e);
        }
        if (t != null) {
            this.transformerCache.put(source.toString().concat(result.toString()), t);
        }
        return t;
    }
}

