/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.stripe.model.FeeRefund;
import com.stripe.model.FeeRefundCollection;
import java.lang.reflect.Type;
import java.util.List;

public class FeeRefundCollectionDeserializer
implements JsonDeserializer<FeeRefundCollection> {
    public static final Type REFUND_LIST_TYPE = new TypeToken<List<FeeRefund>>(){}.getType();

    public FeeRefundCollection deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        if (json.isJsonArray()) {
            List refunds = (List)gson.fromJson(json, REFUND_LIST_TYPE);
            FeeRefundCollection collection = new FeeRefundCollection();
            collection.setData(refunds);
            collection.setHasMore(false);
            collection.setTotalCount(refunds.size());
            return collection;
        }
        return (FeeRefundCollection)gson.fromJson(json, typeOfT);
    }
}

