/*
 * Decompiled with CFR 0.152.
 */
package com.wudaosoft.weixinsdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wudaosoft.weixinsdk.config.WeiXinConfig;
import com.wudaosoft.weixinsdk.type.MediaType;
import com.wudaosoft.weixinsdk.utils.DigestUtils;
import com.wudaosoft.weixinsdk.utils.StringUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonApi {
    private static final Logger log = LoggerFactory.getLogger(CommonApi.class);
    private static final String SPLIT = "";

    public static boolean checkSignature(String token, String signature, String timestamp, String nonce) {
        if (signature == null || timestamp == null || nonce == null) {
            return false;
        }
        Object[] params = new String[]{token, timestamp, nonce};
        Arrays.sort(params);
        String str = StringUtils.arrToString(params, SPLIT);
        str = DigestUtils.sha1(str);
        return signature.equals(str);
    }

    public static Map<String, String> genJsApiSignature(String jsAPITicket, String url) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jsapi_ticket", jsAPITicket);
        params.put("noncestr", CommonApi.create_nonce_str());
        params.put("timestamp", CommonApi.create_timestamp());
        params.put("url", url);
        ArrayList paramsList = new ArrayList(params.entrySet());
        Collections.sort(paramsList, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> mapping1, Map.Entry<String, String> mapping2) {
                return mapping1.getKey().compareTo(mapping2.getKey());
            }
        });
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : paramsList) {
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&");
        }
        String signature = DigestUtils.sha1(sb.deleteCharAt(sb.length() - 1).toString());
        params.put("signature", signature);
        return params;
    }

    public static String mediaUpload(MediaType type, File media, WeiXinConfig wxConf) {
        String url = "/cgi-bin/media/upload?access_token=" + wxConf.getAccessToken() + "&type=" + (Object)((Object)type);
        try {
            JSONObject rs = wxConf.getRequest().post(url, media, "media").json();
            if (rs.containsKey((Object)"media_id")) {
                String mediaId = rs.getString("media_id");
                log.debug("Media upload success! mediaId:" + mediaId);
                return mediaId;
            }
            log.debug("Media upload error:" + rs);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String mediaUploadForever(MediaType type, File media, WeiXinConfig wxConf) {
        String url = "/cgi-bin/material/add_material?access_token=" + wxConf.getAccessToken() + "&type=" + (Object)((Object)type);
        try {
            JSONObject rs = wxConf.getRequest().post(url, media, "media").json();
            if (rs.containsKey((Object)"media_id")) {
                String mediaId = rs.getString("media_id");
                log.debug("Media upload forever upload success! mediaId:" + mediaId);
                return mediaId;
            }
            log.debug("Media upload forever error:" + rs);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String mediaUploadingForArticle(File media, WeiXinConfig wxConf) {
        String url = "/cgi-bin/media/uploadimg?access_token=" + wxConf.getAccessToken();
        try {
            JSONObject rs = wxConf.getRequest().post(url, media, "media").json();
            if (rs.containsKey((Object)"url")) {
                String mediaUrl = rs.getString("url");
                log.debug("Media upload for article success! url:" + mediaUrl);
                return mediaUrl;
            }
            log.debug("Media upload for article error:" + rs);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static File mediaDownLoad(String dir, String mediaId, WeiXinConfig wxConf) {
        String url = "http://api.weixin.qq.com/cgi-bin/media/get?access_token=" + wxConf.getAccessToken() + "&media_id=" + mediaId;
        try {
            return wxConf.getRequest().get(url).file(dir);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static BufferedImage getMaterialImage(String mediaId, WeiXinConfig wxConf) {
        String url = "/cgi-bin/material/get_material?access_token=" + wxConf.getAccessToken();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("media_id", mediaId);
            return wxConf.getRequest().post(url, JSON.toJSONString(params)).image();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String create_nonce_str() {
        return UUID.randomUUID().toString();
    }

    public static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }
}

