/*
 * Decompiled with CFR 0.152.
 */
package com.wudaosoft.weixinsdk;

import com.wudaosoft.net.utils.XmlUtils;
import com.wudaosoft.net.xml.XmlObject;
import com.wudaosoft.weixinsdk.CommonApi;
import com.wudaosoft.weixinsdk.aes.AesException;
import com.wudaosoft.weixinsdk.aes.WXBizMsgCrypt;
import com.wudaosoft.weixinsdk.config.WeiXinConfig;
import com.wudaosoft.weixinsdk.exception.WeiXinException;
import com.wudaosoft.weixinsdk.handler.WeiXinMessageHandler;
import com.wudaosoft.weixinsdk.message.receive.ReceiveEventMsg;
import com.wudaosoft.weixinsdk.message.receive.ReceiveImageMsg;
import com.wudaosoft.weixinsdk.message.receive.ReceiveLinkMsg;
import com.wudaosoft.weixinsdk.message.receive.ReceiveLocationMsg;
import com.wudaosoft.weixinsdk.message.receive.ReceiveTextMsg;
import com.wudaosoft.weixinsdk.message.receive.ReceiveVideoMsg;
import com.wudaosoft.weixinsdk.message.receive.ReceiveVoiceMsg;
import com.wudaosoft.weixinsdk.type.EventType;
import com.wudaosoft.weixinsdk.type.MsgType;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.w3c.dom.Document;

public class WeiXinMessageProcess {
    private static final Logger log = LoggerFactory.getLogger(WeiXinMessageProcess.class);
    private static final String ENCRYPT_TYPE_AES = "aes";
    private WeiXinConfig wxConf;
    private WeiXinMessageHandler messageHandler;

    public WeiXinMessageProcess(WeiXinConfig config, WeiXinMessageHandler messageHandler) {
        Assert.notNull((Object)config, (String)"The WeiXinConfig must not be null");
        Assert.hasText((String)config.getToken(), (String)"The 'sign token' must not be empty");
        Assert.notNull((Object)messageHandler, (String)"The WeiXinMessageHandler must not be null");
        this.wxConf = config;
        this.messageHandler = messageHandler;
    }

    public void setWeixinConfig(WeiXinConfig config) {
        this.wxConf = config;
    }

    public void setMessageHandler(WeiXinMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public WeiXinConfig getWeiXinConfig() {
        return this.wxConf;
    }

    public String processRequest(HttpServletRequest request) throws IOException, WeiXinException, AesException {
        String respXML = null;
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String encryptType = request.getParameter("encrypt_type");
        String msgSignature = request.getParameter("msg_signature");
        if (!ENCRYPT_TYPE_AES.equals(encryptType) && !CommonApi.checkSignature(this.wxConf.getToken(), signature, timestamp, nonce)) {
            return respXML;
        }
        Document doc = XmlUtils.readXml((InputStream)request.getInputStream());
        if (doc != null) {
            XmlObject req = XmlObject.fromDocument((Document)doc);
            if (ENCRYPT_TYPE_AES.equals(encryptType)) {
                String fromEncryptMsg = req.getString("Encrypt");
                if (fromEncryptMsg == null || fromEncryptMsg.trim().length() == 0) {
                    return respXML;
                }
                String decryptedMsg = WXBizMsgCrypt.decryptMsg(msgSignature, timestamp, nonce, fromEncryptMsg, this.wxConf);
                req = XmlObject.fromDocument((Document)XmlUtils.readXml((String)decryptedMsg));
            }
            String msgTypeStr = req.getString("MsgType");
            log.debug("Receive msgType:" + msgTypeStr);
            if (msgTypeStr != null) {
                MsgType msgType = MsgType.getMsgTypeByName(msgTypeStr);
                if (msgType == null) {
                    return respXML;
                }
                switch (msgType) {
                    case text: {
                        respXML = this.messageHandler.processTextMsg((ReceiveTextMsg)req.buildUpperCaseBean(ReceiveTextMsg.class));
                        break;
                    }
                    case image: {
                        respXML = this.messageHandler.processImageMsg((ReceiveImageMsg)req.buildUpperCaseBean(ReceiveImageMsg.class));
                        break;
                    }
                    case voice: {
                        respXML = this.messageHandler.processVoiceMsg((ReceiveVoiceMsg)req.buildUpperCaseBean(ReceiveVoiceMsg.class));
                        break;
                    }
                    case event: {
                        respXML = this.processEventMsg((ReceiveEventMsg)req.buildUpperCaseBean(ReceiveEventMsg.class));
                        break;
                    }
                    case video: {
                        respXML = this.messageHandler.processVideoMsg((ReceiveVideoMsg)req.buildUpperCaseBean(ReceiveVideoMsg.class));
                        break;
                    }
                    case location: {
                        respXML = this.messageHandler.processLocationMsg((ReceiveLocationMsg)req.buildUpperCaseBean(ReceiveLocationMsg.class));
                        break;
                    }
                    case link: {
                        respXML = this.messageHandler.processLinkMsg((ReceiveLinkMsg)req.buildUpperCaseBean(ReceiveLinkMsg.class));
                        break;
                    }
                }
            }
            if (ENCRYPT_TYPE_AES.equals(encryptType) && respXML != null && respXML.trim().length() != 0) {
                respXML = WXBizMsgCrypt.encryptMsg(respXML, CommonApi.create_timestamp(), CommonApi.create_nonce_str(), this.wxConf);
            }
        }
        return respXML;
    }

    private String processEventMsg(ReceiveEventMsg eventMsg) {
        String respXML = null;
        if (eventMsg != null) {
            log.debug("Receive eventType:" + eventMsg.getEvent());
            EventType eventType = EventType.getEventTypeByName(eventMsg.getEvent());
            if (eventType == null) {
                return respXML;
            }
            switch (eventType) {
                case subscribe: {
                    respXML = this.messageHandler.processSubscribeEvent(eventMsg);
                    break;
                }
                case unsubscribe: {
                    respXML = this.messageHandler.processUnsubscribeEvent(eventMsg);
                    break;
                }
                case CLICK: {
                    respXML = this.messageHandler.processClickEvent(eventMsg);
                    break;
                }
                case VIEW: {
                    respXML = this.messageHandler.processViewEvent(eventMsg);
                    break;
                }
                case SCAN: {
                    respXML = this.messageHandler.processScanEvent(eventMsg);
                    break;
                }
                case LOCATION: {
                    respXML = this.messageHandler.processLocationEvent(eventMsg);
                    break;
                }
            }
        }
        return respXML;
    }
}

