/*
 * Decompiled with CFR 0.152.
 */
package com.wudaosoft.weixinsdk.aes;

import com.wudaosoft.weixinsdk.aes.AesException;
import com.wudaosoft.weixinsdk.aes.ByteGroup;
import com.wudaosoft.weixinsdk.aes.PKCS7Encoder;
import com.wudaosoft.weixinsdk.aes.XMLParse;
import com.wudaosoft.weixinsdk.config.WeiXinConfig;
import com.wudaosoft.weixinsdk.utils.SHA1;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class WXBizMsgCrypt {
    private static final String RANDOM_BASE_STR = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final Charset CHARSET = Charset.forName("utf-8");
    private static Base64 base64 = new Base64();

    private WXBizMsgCrypt() {
    }

    static byte[] getNetworkBytesOrder(int sourceNumber) {
        byte[] orderBytes = new byte[4];
        orderBytes[3] = (byte)(sourceNumber & 0xFF);
        orderBytes[2] = (byte)(sourceNumber >> 8 & 0xFF);
        orderBytes[1] = (byte)(sourceNumber >> 16 & 0xFF);
        orderBytes[0] = (byte)(sourceNumber >> 24 & 0xFF);
        return orderBytes;
    }

    static int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 0xFF;
        }
        return sourceNumber;
    }

    static String getRandomStr() {
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            int number = random.nextInt(RANDOM_BASE_STR.length());
            sb.append(RANDOM_BASE_STR.charAt(number));
        }
        return sb.toString();
    }

    public static String encrypt(String randomStr, String text, WeiXinConfig wxConf) throws AesException {
        ByteGroup byteCollector = new ByteGroup();
        byte[] randomStrBytes = randomStr.getBytes(CHARSET);
        byte[] textBytes = text.getBytes(CHARSET);
        byte[] networkBytesOrder = WXBizMsgCrypt.getNetworkBytesOrder(textBytes.length);
        byte[] appidBytes = wxConf.getAppId().getBytes(CHARSET);
        byteCollector.addBytes(randomStrBytes);
        byteCollector.addBytes(networkBytesOrder);
        byteCollector.addBytes(textBytes);
        byteCollector.addBytes(appidBytes);
        byte[] padBytes = PKCS7Encoder.encode(byteCollector.size());
        byteCollector.addBytes(padBytes);
        byte[] unencrypted = byteCollector.toBytes();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(wxConf.getAesKey(), "AES");
            IvParameterSpec iv = new IvParameterSpec(wxConf.getAesKey(), 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            String base64Encrypted = base64.encodeToString(encrypted);
            return base64Encrypted;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AesException(-40006);
        }
    }

    public static String decrypt(String text, WeiXinConfig wxConf) throws AesException {
        String from_appid;
        String xmlContent;
        byte[] original;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec key_spec = new SecretKeySpec(wxConf.getAesKey(), "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(wxConf.getAesKey(), 0, 16));
            cipher.init(2, (Key)key_spec, iv);
            byte[] encrypted = Base64.decodeBase64((String)text);
            original = cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AesException(-40007);
        }
        try {
            byte[] bytes = PKCS7Encoder.decode(original);
            byte[] networkOrder = Arrays.copyOfRange(bytes, 16, 20);
            int xmlLength = WXBizMsgCrypt.recoverNetworkBytesOrder(networkOrder);
            xmlContent = new String(Arrays.copyOfRange(bytes, 20, 20 + xmlLength), CHARSET);
            from_appid = new String(Arrays.copyOfRange(bytes, 20 + xmlLength, bytes.length), CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AesException(-40008);
        }
        if (!from_appid.equals(wxConf.getAppId())) {
            throw new AesException(-40005);
        }
        return xmlContent;
    }

    public static String encryptMsg(String replyMsg, String timeStamp, String nonce, WeiXinConfig wxConf) throws AesException {
        String encrypt = WXBizMsgCrypt.encrypt(WXBizMsgCrypt.getRandomStr(), replyMsg, wxConf);
        String signature = SHA1.getSHA1(wxConf.getToken(), timeStamp, nonce, encrypt);
        String result = XMLParse.generate(encrypt, signature, timeStamp, nonce);
        return result;
    }

    public static String decryptMsg(String msgSignature, String timeStamp, String nonce, String postData, WeiXinConfig wxConf) throws AesException {
        String signature = SHA1.getSHA1(wxConf.getToken(), timeStamp, nonce, postData);
        if (!signature.equals(msgSignature)) {
            throw new AesException(-40001);
        }
        String result = WXBizMsgCrypt.decrypt(postData, wxConf);
        return result;
    }

    public static String verifyUrl(String msgSignature, String timeStamp, String nonce, String echoStr, WeiXinConfig wxConf) throws AesException {
        String signature = SHA1.getSHA1(wxConf.getToken(), timeStamp, nonce, echoStr);
        if (!signature.equals(msgSignature)) {
            throw new AesException(-40001);
        }
        String result = WXBizMsgCrypt.decrypt(echoStr, wxConf);
        return result;
    }
}

