/*
 * Decompiled with CFR 0.152.
 */
package com.wudaosoft.weixinsdk.config;

import com.alibaba.fastjson.JSONObject;
import com.wudaosoft.net.httpclient.HostConfig;
import com.wudaosoft.net.httpclient.HostConfigBuilder;
import com.wudaosoft.net.httpclient.Request;
import com.wudaosoft.weixinsdk.aes.AesException;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class WeiXinConfig {
    private static final Logger log = LoggerFactory.getLogger(WeiXinConfig.class);
    private Lock accessTokenLock = new ReentrantLock();
    private Lock jsAPITicketLock = new ReentrantLock();
    private String appId;
    private String appsecret;
    private String token;
    private String encodingAesKey;
    private String accessToken = null;
    private long expiresIn = 7100000L;
    private long jsAPITicketExpiresIn = 7100000L;
    private String jsAPITicket = null;
    private long tokenSecond = System.currentTimeMillis();
    private long jsAPITicketSecond = System.currentTimeMillis();
    private byte[] aesKey;
    private Request request;

    protected WeiXinConfig() {
    }

    public WeiXinConfig(Request request) {
        this.request = request;
    }

    public WeiXinConfig(String appId, String appsecret) {
        Assert.hasText((String)appId, (String)"'appId' must not be empty");
        Assert.hasText((String)appsecret, (String)"'appsecret' must not be empty");
        this.appId = appId;
        this.appsecret = appsecret;
        HostConfig config = HostConfigBuilder.create((String)"https://api.weixin.qq.com").setConnectionRequestTimeout(500).setConnectTimeout(6000).setSocketTimeout(8000).setPoolSize(200).build();
        this.request = Request.createDefault((HostConfig)config);
    }

    public WeiXinConfig(String appId, String appsecret, String token, String encodingAesKey) throws AesException {
        this(appId, appsecret);
        Assert.hasText((String)token, (String)"'token' must not be empty");
        this.token = token;
        this.encodingAesKey = encodingAesKey;
        if (encodingAesKey != null) {
            if (encodingAesKey.length() != 43) {
                throw new AesException(-40004);
            }
            this.aesKey = Base64.decodeBase64((String)(encodingAesKey + "="));
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public WeiXinConfig setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getAppsecret() {
        return this.appsecret;
    }

    public WeiXinConfig setAppsecret(String appsecret) {
        this.appsecret = appsecret;
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public WeiXinConfig setToken(String token) {
        this.token = token;
        return this;
    }

    public String getEncodingAesKey() {
        return this.encodingAesKey;
    }

    public WeiXinConfig setEncodingAesKey(String encodingAesKey) throws AesException {
        this.encodingAesKey = encodingAesKey;
        if (encodingAesKey != null) {
            if (encodingAesKey.length() != 43) {
                throw new AesException(-40004);
            }
            this.aesKey = Base64.decodeBase64((String)(encodingAesKey + "="));
        }
        return this;
    }

    public byte[] getAesKey() {
        return this.aesKey;
    }

    public String getAccessToken() {
        this.accessTokenLock.lock();
        try {
            JSONObject data;
            long now = System.currentTimeMillis();
            if ((this.accessToken == null || now - this.tokenSecond > this.expiresIn) && (data = this.request.get("/cgi-bin/token?grant_type=client_credential&appid=" + this.appId + "&secret=" + this.appsecret).json()) != null) {
                if (data.containsKey((Object)"access_token")) {
                    this.accessToken = data.getString("access_token");
                    this.expiresIn = (data.getIntValue("expires_in") - 60) * 1000;
                } else {
                    log.debug("getAccessToken error:" + data);
                }
                this.tokenSecond = now;
            }
            String string = this.accessToken;
            return string;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            this.accessTokenLock.unlock();
        }
    }

    public String getJsAPITicket() {
        this.jsAPITicketLock.lock();
        try {
            JSONObject data;
            String url = "/cgi-bin/ticket/getticket?access_token=" + this.getAccessToken() + "&type=jsapi";
            long now = System.currentTimeMillis();
            if ((this.jsAPITicket == null || now - this.jsAPITicketSecond > this.jsAPITicketExpiresIn) && (data = this.request.get(url).json()) != null) {
                if (data.containsKey((Object)"ticket")) {
                    this.jsAPITicket = data.getString("ticket");
                    this.jsAPITicketExpiresIn = (data.getIntValue("expires_in") - 60) * 1000;
                } else {
                    log.debug("getJsAPITicket error:" + data);
                }
                this.jsAPITicketSecond = now;
            }
            String string = this.jsAPITicket;
            return string;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            this.jsAPITicketLock.unlock();
        }
    }

    public Request getRequest() {
        return this.request;
    }

    public JSONObject post(String sufixUrl, String jsonData) {
        try {
            return this.request.post(sufixUrl, jsonData).json();
        }
        catch (Exception e) {
            log.error(String.format("Send data to path[%s] fail." + e.getMessage(), sufixUrl), (Throwable)e);
            return null;
        }
    }

    public JSONObject get(String sufixUrl) {
        return this.get(sufixUrl, (String)null);
    }

    public JSONObject get(String sufixUrl, String jsonData) {
        try {
            return this.request.get(sufixUrl).withStringBody(jsonData).json();
        }
        catch (Exception e) {
            log.error(String.format("get data from path[%s] fail." + e.getMessage(), sufixUrl), (Throwable)e);
            return null;
        }
    }

    public JSONObject get(String sufixUrl, Map<String, String> params) {
        try {
            return this.request.get(sufixUrl, params).json();
        }
        catch (Exception e) {
            log.error(String.format("get data from path[%s] fail." + e.getMessage(), sufixUrl), (Throwable)e);
            return null;
        }
    }
}

