/*
 * Decompiled with CFR 0.152.
 */
package com.wudaosoft.weixinsdk.material;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wudaosoft.weixinsdk.CommonApi;
import com.wudaosoft.weixinsdk.GlobalReturnCode;
import com.wudaosoft.weixinsdk.config.WeiXinConfig;
import com.wudaosoft.weixinsdk.type.MediaType;
import com.wudaosoft.weixinsdk.utils.JsonUtils;
import java.io.File;
import java.util.HashMap;

public class MaterialApi {
    private WeiXinConfig wxConf;

    public MaterialApi(WeiXinConfig wxConf) {
        this.wxConf = wxConf;
    }

    public WeiXinConfig getWeiXinConfig() {
        return this.wxConf;
    }

    public String addImageMaterial(File media) {
        return CommonApi.mediaUploadForever(MediaType.image, media, this.wxConf);
    }

    public String addImageMaterialThumb(File media) {
        return CommonApi.mediaUploadForever(MediaType.thumb, media, this.wxConf);
    }

    public GlobalReturnCode getMaterial(String mediaId) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("media_id", mediaId);
        String url = "/cgi-bin/material/get_material?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, JSON.toJSONString(data));
        return JsonUtils.buildSendResult(resp);
    }

    public GlobalReturnCode delMaterial(String mediaId) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("media_id", mediaId);
        String url = "/cgi-bin/material/del_material?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.get(url, JSON.toJSONString(data));
        return JsonUtils.buildSendResult(resp);
    }

    public GlobalReturnCode getMaterialCount() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", this.wxConf.getAccessToken());
        String url = "/cgi-bin/material/get_materialcount";
        JSONObject resp = this.wxConf.get(url, params);
        return JsonUtils.buildSendResult(resp);
    }

    public GlobalReturnCode batchgetMaterial(MediaType type, int offset, int count) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("type", (Object)type);
        data.put("offset", offset);
        data.put("count", count);
        String url = "/cgi-bin/material/batchget_material?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, JSON.toJSONString(data));
        return JsonUtils.buildSendResult(resp);
    }
}

