/*
 * Decompiled with CFR 0.152.
 */
package com.wudaosoft.weixinsdk.message.response;

import com.wudaosoft.net.xml.XmlObject;
import com.wudaosoft.weixinsdk.message.NewsArticles;
import com.wudaosoft.weixinsdk.type.MsgType;
import java.util.ArrayList;

public class ResponseMsgBuilder {
    private ResponseMsgBuilder() {
    }

    public static String buildTextMsg(String toUserName, String fromUserName, String content) {
        String msgType = MsgType.text.toString();
        long createTime = System.currentTimeMillis() / 1000L;
        String xml = XmlObject.create().put("ToUserName", (Object)toUserName).put("FromUserName", (Object)fromUserName).put("MsgType", (Object)msgType).put("CreateTime", (Object)createTime).put("Content", (Object)content).build();
        return xml;
    }

    public static String buildImageMsg(String toUserName, String fromUserName, String mediaId) {
        String msgType = MsgType.image.toString();
        long createTime = System.currentTimeMillis() / 1000L;
        String xml = XmlObject.create().put("ToUserName", (Object)toUserName).put("FromUserName", (Object)fromUserName).put("MsgType", (Object)msgType).put("CreateTime", (Object)createTime).put("Image", (Object)XmlObject.create().put("MediaId", (Object)mediaId).buildMap()).build();
        return xml;
    }

    public static String buildVoiceMsg(String toUserName, String fromUserName, String mediaId) {
        String msgType = MsgType.voice.toString();
        long createTime = System.currentTimeMillis() / 1000L;
        String xml = XmlObject.create().put("ToUserName", (Object)toUserName).put("FromUserName", (Object)fromUserName).put("MsgType", (Object)msgType).put("CreateTime", (Object)createTime).put("Voice", (Object)XmlObject.create().put("MediaId", (Object)mediaId).buildMap()).build();
        return xml;
    }

    public static String buildVideoMsg(String toUserName, String fromUserName, String mediaId, String title, String description) {
        String msgType = MsgType.video.toString();
        long createTime = System.currentTimeMillis() / 1000L;
        String xml = XmlObject.create().put("ToUserName", (Object)toUserName).put("FromUserName", (Object)fromUserName).put("MsgType", (Object)msgType).put("CreateTime", (Object)createTime).put("Video", (Object)XmlObject.create().put("MediaId", (Object)mediaId).put("Title", (Object)title).put("Description", (Object)description).buildMap()).build();
        return xml;
    }

    public static String buildMusicMsg(String toUserName, String fromUserName, String title, String description, String musicUrl, String hqMusicUrl, String thumbMediaId) {
        String msgType = MsgType.music.toString();
        long createTime = System.currentTimeMillis() / 1000L;
        String xml = XmlObject.create().put("ToUserName", (Object)toUserName).put("FromUserName", (Object)fromUserName).put("MsgType", (Object)msgType).put("CreateTime", (Object)createTime).put("Music", (Object)XmlObject.create().put("Title", (Object)title).put("Description", (Object)description).put("MusicUrl", (Object)musicUrl).put("HQMusicUrl", (Object)hqMusicUrl).put("ThumbMediaId", (Object)thumbMediaId).buildMap()).build();
        return xml;
    }

    public static String buildNewsMsg(String toUserName, String fromUserName, NewsArticles ... articles) {
        if (articles == null) {
            return "";
        }
        String msgType = MsgType.news.toString();
        long createTime = System.currentTimeMillis() / 1000L;
        XmlObject xml = XmlObject.create().put("ToUserName", (Object)toUserName).put("FromUserName", (Object)fromUserName).put("MsgType", (Object)msgType).put("CreateTime", (Object)createTime).put("ArticleCount", (Object)articles.length);
        ArrayList<XmlObject> item = new ArrayList<XmlObject>(articles.length);
        for (NewsArticles article : articles) {
            XmlObject articleXml = XmlObject.create().put("Title", (Object)article.getTitle()).put("Description", (Object)article.getDescription()).put("Url", (Object)article.getUrl()).put("PicUrl", (Object)article.getPicUrl());
            item.add(XmlObject.create().put("item", (Object)articleXml));
        }
        xml.put("Articles", item);
        return xml.build();
    }

    public static void main(String[] args) {
        NewsArticles article = new NewsArticles();
        article.setTitle("\u54c8\u54c8");
        article.setDescription("\u563f\u563f");
        article.setPicUrl("http://1.a");
        article.setUrl("http://2.a");
        NewsArticles article1 = new NewsArticles();
        article1.setTitle("\u5988\u7684");
        article1.setDescription("\u8349");
        article1.setPicUrl("http://3.a");
        article1.setUrl("http://4.a");
        System.out.println(ResponseMsgBuilder.buildNewsMsg("touser", "fromuser", article, article));
    }
}

