/*
 * Decompiled with CFR 0.152.
 */
package com.wudaosoft.weixinsdk.message.send;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.wudaosoft.weixinsdk.GlobalReturnCode;
import com.wudaosoft.weixinsdk.config.WeiXinConfig;
import com.wudaosoft.weixinsdk.message.NewsArticles;
import com.wudaosoft.weixinsdk.type.MsgType;
import com.wudaosoft.weixinsdk.utils.JsonUtils;

public class CustomMsgSender {
    private WeiXinConfig wxConf;

    public CustomMsgSender(WeiXinConfig wxConf) {
        this.wxConf = wxConf;
    }

    public WeiXinConfig getWeiXinConfig() {
        return this.wxConf;
    }

    public GlobalReturnCode sendTextMsg(String toUser, String content) {
        String msgType = MsgType.text.toString();
        JSONObject req = new JSONObject();
        req.put("touser", (Object)toUser);
        req.put("msgtype", (Object)msgType);
        JSONObject sub = new JSONObject();
        sub.put("content", (Object)content);
        req.put("text", (Object)sub);
        String url = "/cgi-bin/message/custom/send?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, req.toString());
        return JsonUtils.buildSendResult(resp);
    }

    public GlobalReturnCode sendImageMsg(String toUser, String mediaId) {
        String msgType = MsgType.image.toString();
        JSONObject req = new JSONObject();
        req.put("touser", (Object)toUser);
        req.put("msgtype", (Object)msgType);
        JSONObject sub = new JSONObject();
        sub.put("media_id", (Object)mediaId);
        req.put("image", (Object)sub);
        String url = "/cgi-bin/message/custom/send?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, req.toString());
        return JsonUtils.buildSendResult(resp);
    }

    public GlobalReturnCode sendVoiceMsg(String toUser, String mediaId) {
        String msgType = MsgType.voice.toString();
        JSONObject req = new JSONObject();
        req.put("touser", (Object)toUser);
        req.put("msgtype", (Object)msgType);
        JSONObject sub = new JSONObject();
        sub.put("media_id", (Object)mediaId);
        req.put("voice", (Object)sub);
        String url = "/cgi-bin/message/custom/send?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, req.toString());
        return JsonUtils.buildSendResult(resp);
    }

    public GlobalReturnCode sendVideoMsg(String toUser, String mediaId, String title, String description) {
        String msgType = MsgType.video.toString();
        JSONObject req = new JSONObject();
        req.put("touser", (Object)toUser);
        req.put("msgtype", (Object)msgType);
        JSONObject sub = new JSONObject();
        sub.put("media_id", (Object)mediaId);
        sub.put("title", (Object)title);
        sub.put("description", (Object)description);
        req.put("video", (Object)sub);
        String url = "/cgi-bin/message/custom/send?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, req.toString());
        return JsonUtils.buildSendResult(resp);
    }

    public GlobalReturnCode sendMusicMsg(String toUser, String title, String description, String musicUrl, String hqMusicUrl, String thumbMediaId) {
        String msgType = MsgType.music.toString();
        JSONObject req = new JSONObject();
        req.put("touser", (Object)toUser);
        req.put("msgtype", (Object)msgType);
        JSONObject sub = new JSONObject();
        sub.put("title", (Object)title);
        sub.put("description", (Object)description);
        sub.put("musicurl", (Object)musicUrl);
        sub.put("hqmusicurl", (Object)hqMusicUrl);
        sub.put("description", (Object)description);
        sub.put("thumb_media_id", (Object)thumbMediaId);
        req.put("music", (Object)sub);
        String url = "/cgi-bin/message/custom/send?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, req.toString());
        return JsonUtils.buildSendResult(resp);
    }

    public GlobalReturnCode sendNewsMsg(String toUser, NewsArticles ... articles) {
        if (articles == null) {
            return new GlobalReturnCode().systemError();
        }
        String msgType = MsgType.news.toString();
        JSONObject req = new JSONObject();
        req.put("touser", (Object)toUser);
        req.put("msgtype", (Object)msgType);
        JSONArray array = new JSONArray();
        for (NewsArticles article : articles) {
            JSONObject thr = new JSONObject();
            thr.put("Title", (Object)article.getTitle());
            thr.put("Description", (Object)article.getDescription());
            thr.put("Url", (Object)article.getUrl());
            thr.put("PicUrl", (Object)article.getPicUrl());
            array.add((Object)thr);
        }
        JSONObject sub = new JSONObject();
        sub.put("articles", (Object)array);
        req.put("news", (Object)sub);
        String url = "/cgi-bin/message/custom/send?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, req.toString());
        return JsonUtils.buildSendResult(resp);
    }
}

