/*
 * Decompiled with CFR 0.152.
 */
package com.wudaosoft.weixinsdk.message.send.article;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.wudaosoft.weixinsdk.GlobalReturnCode;
import com.wudaosoft.weixinsdk.config.WeiXinConfig;
import com.wudaosoft.weixinsdk.message.send.article.Article;
import com.wudaosoft.weixinsdk.message.send.article.Articles;
import com.wudaosoft.weixinsdk.utils.JsonUtils;
import java.util.HashMap;

public class ArticlesApi {
    private WeiXinConfig wxConf;

    public ArticlesApi(WeiXinConfig wxConf) {
        this.wxConf = wxConf;
    }

    public WeiXinConfig getWeiXinConfig() {
        return this.wxConf;
    }

    public GlobalReturnCode articlesUpload(Articles articles) {
        return this.articlesUploadByJsonString(JSON.toJSONString((Object)articles, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty}));
    }

    public GlobalReturnCode articlesUploadToMaterial(Articles articles) {
        return this.articlesUploadToMaterialByJsonString(JSON.toJSONString((Object)articles, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty}));
    }

    public GlobalReturnCode articlesUpdate(String mediaId, String index, Article article) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("media_id", mediaId);
        map.put("index", index);
        map.put("articles", article);
        return this.articlesUpdateByJsonString(JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty}));
    }

    public GlobalReturnCode articlesUploadByJsonString(String jsonString) {
        String url = "/cgi-bin/media/uploadnews?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, jsonString);
        return JsonUtils.buildSendResult(resp);
    }

    public GlobalReturnCode articlesUploadToMaterialByJsonString(String jsonString) {
        String url = "/cgi-bin/material/add_news?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, jsonString);
        return JsonUtils.buildSendResult(resp);
    }

    public GlobalReturnCode articlesUpdateByJsonString(String jsonString) {
        String url = "/cgi-bin/material/update_news?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, jsonString);
        return JsonUtils.buildSendResult(resp);
    }

    public GlobalReturnCode articlesSend(String mediaId) {
        HashMap<String, Boolean> filter = new HashMap<String, Boolean>();
        filter.put("is_to_all", true);
        HashMap<String, String> mpnews = new HashMap<String, String>();
        mpnews.put("media_id", mediaId);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("filter", filter);
        data.put("mpnews", mpnews);
        data.put("msgtype", "mpnews");
        String url = "/cgi-bin/message/mass/sendall?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, JSON.toJSONString(data));
        return JsonUtils.buildSendResult(resp);
    }

    public GlobalReturnCode articlesPreviewToOpenId(String openId, String mediaId) {
        HashMap<String, String> mpnews = new HashMap<String, String>();
        mpnews.put("media_id", mediaId);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("touser", openId);
        data.put("mpnews", mpnews);
        data.put("msgtype", "mpnews");
        String url = "/cgi-bin/message/mass/preview?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, JSON.toJSONString(data));
        return JsonUtils.buildSendResult(resp);
    }

    public GlobalReturnCode articlesPreviewToWxUsername(String wxUsername, String mediaId) {
        HashMap<String, String> mpnews = new HashMap<String, String>();
        mpnews.put("media_id", mediaId);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("towxname", wxUsername);
        data.put("mpnews", mpnews);
        data.put("msgtype", "mpnews");
        String url = "/cgi-bin/message/mass/preview?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, JSON.toJSONString(data));
        return JsonUtils.buildSendResult(resp);
    }
}

