/*
 * Decompiled with CFR 0.152.
 */
package com.wudaosoft.weixinsdk.oauth2;

import com.alibaba.fastjson.JSONObject;
import com.wudaosoft.weixinsdk.config.WeiXinConfig;
import com.wudaosoft.weixinsdk.oauth2.OAuth2AccessToken;
import com.wudaosoft.weixinsdk.oauth2.OAuth2UserInfo;
import com.wudaosoft.weixinsdk.utils.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Api {
    private static final Logger log = LoggerFactory.getLogger(OAuth2Api.class);
    private static final String SNSAPI_BASE = "snsapi_base";
    private static final String SNSAPI_USERINFO = "snsapi_userinfo";
    private WeiXinConfig wxConf;

    public OAuth2Api(WeiXinConfig wxConf) {
        this.wxConf = wxConf;
    }

    public WeiXinConfig getWeiXinConfig() {
        return this.wxConf;
    }

    public String buildBaseOAuth2Link(String linkText, String redirectUri, String state) {
        return this.buildOAuth2Link(linkText, redirectUri, SNSAPI_BASE, state);
    }

    public String buildUserinfoOAuth2Link(String linkText, String redirectUri, String state) {
        return this.buildOAuth2Link(linkText, redirectUri, SNSAPI_USERINFO, state);
    }

    private String buildOAuth2Link(String linkText, String redirectUri, String scope, String state) {
        if (state == null) {
            state = "";
        }
        StringBuilder link = new StringBuilder();
        try {
            link.append("<a href=\"").append("https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + this.wxConf.getAppId()).append("&redirect_uri=" + URLEncoder.encode(redirectUri, "UTF-8")).append("&response_type=code").append("&scope=" + scope).append("&state=" + state).append("#wechat_redirect").append("\">");
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        link.append(linkText).append("</a>");
        return link.toString();
    }

    public OAuth2AccessToken getOAuth2AccessToken(String code) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("appid", this.wxConf.getAppId());
        params.put("secret", this.wxConf.getAppsecret());
        params.put("code", code);
        params.put("grant_type", "authorization_code");
        JSONObject resp = this.wxConf.get("/sns/oauth2/access_token", params);
        return JsonUtils.buildRequestResult(resp, OAuth2AccessToken.class);
    }

    public OAuth2AccessToken refreshOAuth2AccessToken(String refreshToken) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("appid", this.wxConf.getAppId());
        params.put("refresh_token", refreshToken);
        params.put("grant_type", "refresh_token");
        JSONObject resp = this.wxConf.get("/sns/oauth2/refresh_token", params);
        return JsonUtils.buildRequestResult(resp, OAuth2AccessToken.class);
    }

    public OAuth2UserInfo oauth2UserInfo(String oauth2AccessToken, String openId, String lang) {
        String url = "/sns/userinfo?access_token=" + oauth2AccessToken + "&openid=" + openId;
        if (lang != null) {
            url = url + "&lang=" + lang;
        }
        JSONObject resp = this.wxConf.get(url);
        return JsonUtils.buildRequestResult(resp, OAuth2UserInfo.class);
    }
}

