/*
 * Decompiled with CFR 0.152.
 */
package com.wudaosoft.weixinsdk.qrcode;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wudaosoft.net.httpclient.Request;
import com.wudaosoft.weixinsdk.config.WeiXinConfig;
import com.wudaosoft.weixinsdk.qrcode.QRCode;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRCodeApi {
    private final Logger log = LoggerFactory.getLogger(QRCodeApi.class);
    private final String QR_SCENE = "QR_SCENE";
    private final String QR_LIMIT_SCENE = "QR_LIMIT_SCENE";
    private WeiXinConfig wxConf;

    public QRCodeApi(WeiXinConfig wxConf) {
        this.wxConf = wxConf;
    }

    public WeiXinConfig getWeiXinConfig() {
        return this.wxConf;
    }

    public QRCode createQRCode(int sceneId) {
        return this.createQRCode("QR_LIMIT_SCENE", sceneId, 0);
    }

    public QRCode createTempQRCode(int sceneId, int expireSeconds) {
        return this.createQRCode("QR_SCENE", sceneId, expireSeconds);
    }

    public String showQRCode(String ticket) throws URISyntaxException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ticket", ticket);
        String url = Request.buildReqUrl((String)"https://mp.weixin.qq.com/cgi-bin/showqrcode", params);
        return url;
    }

    private QRCode createQRCode(String actionName, int sceneId, int expireSeconds) {
        JSONObject req = new JSONObject();
        JSONObject sub = new JSONObject();
        JSONObject thr = new JSONObject();
        thr.put("scene_id", (Object)sceneId);
        sub.put("scene", (Object)thr);
        if (expireSeconds != 0) {
            req.put("expire_seconds", (Object)expireSeconds);
        }
        req.put("action_name", (Object)actionName);
        req.put("action_info", (Object)sub);
        String url = "/cgi-bin/qrcode/create?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, req.toString());
        QRCode qrc = new QRCode();
        if (resp != null) {
            try {
                qrc = (QRCode)JSON.toJavaObject((JSON)resp, QRCode.class);
                if (qrc != null && qrc.getTicket() != null) {
                    qrc.setUrl(this.showQRCode(qrc.getTicket()));
                }
                return qrc;
            }
            catch (Exception e) {
                qrc.systemError();
                this.log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            qrc.systemError();
        }
        return qrc;
    }
}

