/*
 * Decompiled with CFR 0.152.
 */
package com.wudaosoft.weixinsdk.usermanage;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.wudaosoft.weixinsdk.config.WeiXinConfig;
import com.wudaosoft.weixinsdk.usermanage.SubscribeList;
import com.wudaosoft.weixinsdk.usermanage.UserInfo;
import com.wudaosoft.weixinsdk.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserApi {
    private static final Logger log = LoggerFactory.getLogger(UserApi.class);
    private WeiXinConfig wxConf;

    public UserApi(WeiXinConfig wxConf) {
        this.wxConf = wxConf;
    }

    public WeiXinConfig getWeiXinConfig() {
        return this.wxConf;
    }

    public UserInfo userInfo(String openId, String lang) {
        String url = "/cgi-bin/user/info?access_token=" + this.wxConf.getAccessToken() + "&openid=" + openId;
        if (lang != null) {
            url = url + "&lang=" + lang;
        }
        JSONObject resp = this.wxConf.get(url);
        return JsonUtils.buildRequestResult(resp, UserInfo.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SubscribeList userGet(String nextOpenId) {
        if (nextOpenId == null) {
            nextOpenId = "";
        }
        String url = "/cgi-bin/user/get?access_token=" + this.wxConf.getAccessToken() + "&next_openid=" + nextOpenId;
        JSONObject resp = this.wxConf.get(url);
        SubscribeList list = new SubscribeList();
        if (resp != null) {
            if (!resp.containsKey((Object)"total")) return JsonUtils.buildRequestResult(resp, SubscribeList.class);
            try {
                list.setTotal(resp.getIntValue("total"));
                list.setCount(resp.getIntValue("count"));
                list.setNextOpenId(resp.getString("next_openid"));
                if (list.getCount() <= 0) return list;
                JSONArray array = resp.getJSONObject("data").getJSONArray("openid");
                int i = 0;
                while (i < array.size()) {
                    list.addOpenId(array.getString(i));
                    ++i;
                }
                return list;
            }
            catch (JSONException e) {
                list.systemError();
                log.error(e.getMessage(), (Throwable)e);
                return list;
            }
        } else {
            list.systemError();
        }
        return list;
    }
}

