/*
 * Decompiled with CFR 0.152.
 */
package com.wudaosoft.weixinsdk.usermanage;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.wudaosoft.weixinsdk.GlobalReturnCode;
import com.wudaosoft.weixinsdk.config.WeiXinConfig;
import com.wudaosoft.weixinsdk.usermanage.Group;
import com.wudaosoft.weixinsdk.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupApi {
    private static final Logger log = LoggerFactory.getLogger(UserGroupApi.class);
    private WeiXinConfig wxConf;

    public UserGroupApi(WeiXinConfig wxConf) {
        this.wxConf = wxConf;
    }

    public WeiXinConfig getWeiXinConfig() {
        return this.wxConf;
    }

    public GlobalReturnCode createGroup(String name) {
        JSONObject req = new JSONObject();
        JSONObject sub = new JSONObject();
        sub.put("name", (Object)name);
        req.put("group", (Object)sub);
        String url = "/cgi-bin/groups/create?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, req.toString());
        return JsonUtils.buildSendResult(resp);
    }

    public GlobalReturnCode updateGroup(int id, String name) {
        JSONObject req = new JSONObject();
        JSONObject sub = new JSONObject();
        sub.put("id", (Object)id);
        sub.put("name", (Object)name);
        req.put("group", (Object)sub);
        String url = "/cgi-bin/groups/update?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, req.toString());
        return JsonUtils.buildSendResult(resp);
    }

    public List<Group> getGroups() {
        String url = "/cgi-bin/groups/get?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.get(url);
        try {
            if (resp != null) {
                if (resp.containsKey((Object)"groups")) {
                    JSONArray groups = resp.getJSONArray("groups");
                    ArrayList<Group> groupList = new ArrayList<Group>(groups.size());
                    for (int i = 0; i < groups.size(); ++i) {
                        JSONObject g = groups.getJSONObject(i);
                        Group group = new Group();
                        group.setId(g.getIntValue("id"));
                        group.setName(g.getString("name"));
                        group.setCount(g.getIntValue("count"));
                        groupList.add(group);
                    }
                    return groupList;
                }
                log.error("getGroups error:" + resp);
            }
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public int getGroupId(String openId) {
        JSONObject req = new JSONObject();
        req.put("openid", (Object)openId);
        String url = "/cgi-bin/groups/getid?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, req.toString());
        if (resp != null) {
            if (resp.containsKey((Object)"groupid")) {
                return resp.getIntValue("groupid");
            }
            log.error("getGroupId error:" + resp);
        }
        return -1;
    }

    public GlobalReturnCode moveToGroup(String openId, int toGroupId) {
        JSONObject req = new JSONObject();
        req.put("openid", (Object)openId);
        req.put("to_groupid", (Object)toGroupId);
        String url = "/cgi-bin/groups/members/update?access_token=" + this.wxConf.getAccessToken();
        JSONObject resp = this.wxConf.post(url, req.toString());
        return JsonUtils.buildSendResult(resp);
    }
}

