/*
 * Decompiled with CFR 0.152.
 */
package com.wudaosoft.weixinsdk.utils;

import java.security.MessageDigest;
import org.apache.commons.codec.binary.Base64;

public class DigestUtils {
    private static final String MD5_ALGORITHM = "MD5";
    private static final String SHA1_ALGORITHM = "SHA1";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String sha1(String str) {
        return DigestUtils.encode(SHA1_ALGORITHM, str);
    }

    public static String md5(String str) {
        return DigestUtils.encode(MD5_ALGORITHM, str);
    }

    public static String md5EncryptAndBase64(String str) {
        return DigestUtils.encodeBase64(DigestUtils.md5Encrypt(str));
    }

    private static byte[] md5Encrypt(String encryptStr) {
        try {
            MessageDigest md5 = MessageDigest.getInstance(MD5_ALGORITHM);
            md5.update(encryptStr.getBytes("utf8"));
            return md5.digest();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String encodeBase64(byte[] b) {
        String str = Base64.encodeBase64String((byte[])b);
        return str;
    }

    private static String encode(String algorithm, String str) {
        if (str == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            messageDigest.update(str.getBytes("UTF-8"));
            return DigestUtils.byte2String(messageDigest.digest());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String byte2String(byte[] bytes) {
        int len = bytes.length;
        StringBuilder sb = new StringBuilder(len * 2);
        for (int i = 0; i < len; ++i) {
            sb.append(HEX_DIGITS[bytes[i] >> 4 & 0xF]);
            sb.append(HEX_DIGITS[bytes[i] & 0xF]);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println("md5:" + DigestUtils.md5("\u5475\u5475"));
        System.out.println("sha1:" + DigestUtils.sha1("\u5475\u5475"));
    }
}

