/*
 * Decompiled with CFR 0.152.
 */
package com.wudaosoft.weixinsdk.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.wudaosoft.weixinsdk.GlobalReturnCode;

public class JsonUtils {
    public static String getString(JSONObject json, String key) {
        if (json == null || key == null) {
            return null;
        }
        try {
            return json.getString(key);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public static int getInt(JSONObject json, String key) {
        return JsonUtils.getInt(json, key, -2147483647);
    }

    public static int getInt(JSONObject json, String key, int defaultValue) {
        int rs = defaultValue;
        if (json != null && key != null) {
            try {
                rs = json.getIntValue(key);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return rs;
    }

    public static boolean getBoolean(JSONObject json, String key) {
        return JsonUtils.getBoolean(json, key, false);
    }

    public static boolean getBoolean(JSONObject json, String key, boolean defaultValue) {
        boolean rs = defaultValue;
        if (json != null && key != null) {
            try {
                rs = json.getBoolean(key);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return rs;
    }

    public static GlobalReturnCode buildSendResult(JSONObject resp) {
        GlobalReturnCode gc = new GlobalReturnCode();
        if (resp != null) {
            if (resp.containsKey((Object)"errcode")) {
                try {
                    gc = (GlobalReturnCode)JSON.toJavaObject((JSON)resp, GlobalReturnCode.class);
                }
                catch (Exception e) {
                    gc.systemError();
                }
            } else {
                gc.setData(resp);
            }
        } else {
            gc.systemError();
        }
        return gc;
    }

    public static <T extends GlobalReturnCode> T buildRequestResult(JSONObject resp, Class<T> t) {
        try {
            GlobalReturnCode o = (GlobalReturnCode)t.newInstance();
            if (resp != null) {
                try {
                    o = (GlobalReturnCode)JSONObject.toJavaObject((JSON)resp, t);
                }
                catch (Exception e) {
                    o.systemError();
                }
            } else {
                o.systemError();
            }
            return (T)o;
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        return null;
    }
}

