/*
 * Decompiled with CFR 0.152.
 */
package org.marker.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Sign {
    private static Logger logger = LoggerFactory.getLogger(Sign.class);

    private Sign() {
    }

    public static void main(String[] args) {
        String jsapiTicket = "jsapi_ticket";
        String url = "http://example.com";
        JSONObject ret = Sign.sign(jsapiTicket, url);
        for (Map.Entry entry : ret.entrySet()) {
            System.out.println(entry.getKey() + ", " + entry.getValue());
        }
    }

    public static JSONObject sign(String jsapiTicket, String url) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String nonceStr = Sign.createNonceStr();
        String timestamp = Sign.createTimestamp();
        String signature = "";
        String string1 = "jsapi_ticket=" + jsapiTicket + "&noncestr=" + nonceStr + "&timestamp=" + timestamp + "&url=" + url;
        logger.debug(string1);
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(string1.getBytes("UTF-8"));
            signature = Sign.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("", (Throwable)e);
        }
        ret.put("url", url);
        ret.put("jsapi_ticket", jsapiTicket);
        ret.put("nonceStr", nonceStr);
        ret.put("timestamp", timestamp);
        ret.put("signature", signature);
        ret.put("appId", "wxb77ebe16b2abdd83");
        return new JSONObject(ret);
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    private static String createNonceStr() {
        return UUID.randomUUID().toString();
    }

    private static String createTimestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }
}

