/*
 * Decompiled with CFR 0.152.
 */
package org.marker.weixin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.marker.weixin.msg.Msg;
import org.marker.weixin.msg.Msg4Event;
import org.marker.weixin.msg.Msg4Head;
import org.marker.weixin.msg.Msg4Image;
import org.marker.weixin.msg.Msg4Link;
import org.marker.weixin.msg.Msg4Location;
import org.marker.weixin.msg.Msg4Text;
import org.marker.weixin.msg.Msg4Video;
import org.marker.weixin.msg.Msg4Voice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class Session {
    private Logger logger = LoggerFactory.getLogger(Session.class);
    private InputStream is;
    private OutputStream os;
    private static DocumentBuilder builder;
    private static TransformerFactory tffactory;

    public void process(InputStream is, OutputStream os) {
        this.os = os;
        this.is = is;
        try {
            Document document = builder.parse(is);
            Msg4Head head = new Msg4Head();
            head.read(document);
            String type = head.getMsgType();
            if ("text".equals(type)) {
                Msg4Text msg = new Msg4Text(head);
                msg.read(document);
                this.onTextMsg(msg);
            } else if ("image".equals(type)) {
                Msg4Image msg = new Msg4Image(head);
                msg.read(document);
                this.onImageMsg(msg);
            } else if ("event".equals(type)) {
                Msg4Event msg = new Msg4Event(head);
                msg.read(document);
                this.onEventMsg(msg);
            } else if ("link".equals(type)) {
                Msg4Link msg = new Msg4Link(head);
                msg.read(document);
                this.onLinkMsg(msg);
            } else if ("location".equals(type)) {
                Msg4Location msg = new Msg4Location(head);
                msg.read(document);
                this.onLocationMsg(msg);
            } else if ("voice".equals(type)) {
                Msg4Voice msg = new Msg4Voice(head);
                msg.read(document);
                this.onVoiceMsg(msg);
            } else if ("video".equals(type)) {
                Msg4Video msg = new Msg4Video(head);
                msg.read(document);
                this.onVideoMsg(msg);
            } else {
                this.onErrorMsg(-1);
            }
        }
        catch (SAXException e) {
            this.logger.error("", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("", (Throwable)e);
        }
    }

    public void callback(Msg msg) {
        Document document = builder.newDocument();
        msg.write(document);
        try {
            Transformer transformer = tffactory.newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(new OutputStreamWriter(this.os, "utf-8")));
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
    }

    public void send(Msg msg) {
        this.callback(msg);
    }

    public void close() {
        try {
            if (this.is != null) {
                this.is.close();
            }
            if (this.os != null) {
                this.os.flush();
                this.os.close();
            }
        }
        catch (IOException e) {
            this.logger.error("", (Throwable)e);
        }
    }

    public abstract void onTextMsg(Msg4Text var1);

    public abstract void onImageMsg(Msg4Image var1);

    public abstract void onEventMsg(Msg4Event var1);

    public abstract void onLinkMsg(Msg4Link var1);

    public abstract void onLocationMsg(Msg4Location var1);

    public abstract void onVoiceMsg(Msg4Voice var1);

    public abstract void onVideoMsg(Msg4Video var1);

    public abstract void onErrorMsg(int var1);

    static {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        tffactory = TransformerFactory.newInstance();
    }
}

