/*
 * Decompiled with CFR 0.152.
 */
package org.marker.weixin.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.marker.utils.HttpUtil;
import org.marker.weixin.api.domain.QRCode;
import org.marker.weixin.exception.WeixinException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardCouponsUtils {
    private static Logger logger = LoggerFactory.getLogger(CardCouponsUtils.class);
    private static final String URL_CARD_CREATE = "https://api.weixin.qq.com/card/create";
    private static final String URL_QRCODE_CREATE = "https://api.weixin.qq.com/card/qrcode/create";

    public static String create(String accessToken, String body) throws WeixinException {
        String url = URL_CARD_CREATE + "?" + "access_token=" + accessToken;
        String json = HttpUtil.sendHttpsPOST(url, body);
        JSONObject obj = JSON.parseObject((String)json);
        String cardId = obj.getString("card_id");
        if (null == cardId) {
            logger.error("{}", (Object)json);
            throw new WeixinException("\u521b\u5efa\u5361\u5238\u5931\u8d25\uff01result=" + json);
        }
        return cardId;
    }

    public static QRCode createQrcode(String accessToken, String body) throws WeixinException {
        String url = URL_QRCODE_CREATE + "?" + "access_token=" + accessToken;
        String json = HttpUtil.sendHttpsPOST(url, body);
        QRCode qrCode = (QRCode)JSON.parseObject((String)json, QRCode.class);
        if (null == qrCode) {
            logger.error("{}", (Object)json);
            throw new WeixinException(json);
        }
        return qrCode;
    }
}

