/*
 * Decompiled with CFR 0.152.
 */
package org.marker.weixin.msg;

import java.util.ArrayList;
import java.util.List;
import org.marker.weixin.msg.Data4Item;
import org.marker.weixin.msg.Msg;
import org.marker.weixin.msg.Msg4Head;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Msg4ImageText
extends Msg {
    private String articleCount;
    private List<Data4Item> items = new ArrayList<Data4Item>(3);
    private String funcFlag;

    public Msg4ImageText() {
        this.head = new Msg4Head();
        this.head.setMsgType("news");
    }

    @Override
    public void write(Document document) {
        Element root = document.createElement("xml");
        this.head.write(root, document);
        Element articleCountElement = document.createElement("ArticleCount");
        articleCountElement.setTextContent(this.articleCount);
        Element articlesElement = document.createElement("Articles");
        int size = Integer.parseInt(this.articleCount);
        for (int i = 0; i < size; ++i) {
            Data4Item currentItem = this.items.get(i);
            Element itemElement = document.createElement("item");
            Element titleElement = document.createElement("Title");
            titleElement.setTextContent(currentItem.getTitle());
            Element descriptionElement = document.createElement("Description");
            descriptionElement.setTextContent(currentItem.getDescription());
            Element picUrlElement = document.createElement("PicUrl");
            picUrlElement.setTextContent(currentItem.getPicUrl());
            Element urlElement = document.createElement("Url");
            urlElement.setTextContent(currentItem.getUrl());
            itemElement.appendChild(titleElement);
            itemElement.appendChild(descriptionElement);
            itemElement.appendChild(picUrlElement);
            itemElement.appendChild(urlElement);
            articlesElement.appendChild(itemElement);
        }
        Element funcFlagElement = document.createElement("FuncFlag");
        funcFlagElement.setTextContent(this.funcFlag);
        root.appendChild(articleCountElement);
        root.appendChild(articlesElement);
        document.appendChild(root);
    }

    @Override
    public void read(Document document) {
    }

    public String getFuncFlag() {
        return this.funcFlag;
    }

    public void setFuncFlag(String funcFlag) {
        this.funcFlag = funcFlag;
    }

    public void addItem(Data4Item item) {
        this.items.add(item);
        this.reflushArticleCount();
    }

    public void removeItem(int index) {
        this.items.remove(index);
        this.reflushArticleCount();
    }

    private void reflushArticleCount() {
        this.articleCount = "" + this.items.size();
    }
}

