/*
 * Decompiled with CFR 0.152.
 */
package org.marker.weixin.web;

import com.alibaba.fastjson.JSON;
import org.marker.utils.HttpUtil;
import org.marker.weixin.exception.WeixinException;
import org.marker.weixin.web.domain.UserInfo;
import org.marker.weixin.web.domain.WebAccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessTokenUtils {
    private static Logger logger = LoggerFactory.getLogger(AccessTokenUtils.class);
    public static final String URL_ACCESSTOKEN = "https://api.weixin.qq.com/sns/oauth2/access_token";
    public static final String URL_REFRESH_TOKEN = "https://api.weixin.qq.com/sns/oauth2/refresh_token";
    public static final String URL_USER_INFO = "https://api.weixin.qq.com/sns/userinfo";
    private static long getTime;
    private static WebAccessToken accessToken;

    public static WebAccessToken getAccessToken(String code) throws WeixinException {
        long currentTime;
        if (null != accessToken && (currentTime = System.currentTimeMillis()) - getTime < 0x6DDD00L) {
            return accessToken;
        }
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=wxb77ebe16b2abdd83&secret=ca3ef339ee50485541b63151f0b8848a&code=" + code + "&grant_type=authorization_code";
        String json = HttpUtil.sendHttpsGET(url);
        getTime = System.currentTimeMillis();
        accessToken = (WebAccessToken)JSON.parseObject((String)json, WebAccessToken.class);
        if (null == accessToken) {
            logger.error("{}", (Object)json);
            throw new WeixinException(json);
        }
        return accessToken;
    }

    public static WebAccessToken refreshAccessToken(String code) throws WeixinException {
        long currentTime;
        if (null != accessToken && (currentTime = System.currentTimeMillis()) - getTime < 0x6DDD00L) {
            return accessToken;
        }
        String url = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=wxb77ebe16b2abdd83&grant_type=refresh_token&refresh_token=REFRESH_TOKEN";
        String json = HttpUtil.sendHttpsGET(url);
        getTime = System.currentTimeMillis();
        accessToken = (WebAccessToken)JSON.parseObject((String)json, WebAccessToken.class);
        if (null == accessToken) {
            logger.error("{}", (Object)json);
            throw new WeixinException(json);
        }
        return accessToken;
    }

    public static UserInfo getUserInfo(String accessToken, String openid, String lang) {
        String url = "https://api.weixin.qq.com/sns/userinfo?access_token=" + accessToken + "&openid=" + openid + "&lang=" + lang;
        String json = HttpUtil.sendHttpsGET(url);
        getTime = System.currentTimeMillis();
        return (UserInfo)JSON.parseObject((String)json, UserInfo.class);
    }

    public static UserInfo getUserInfo(String accessToken, String openid) {
        return AccessTokenUtils.getUserInfo(accessToken, openid, "zh_CN");
    }
}

