package com.spring.boxes.dollar;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.experimental.UtilityClass;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

import java.util.List;
import java.util.Map;

@Deprecated // DefaultControllerAdvice
@UtilityClass
public final class AdviceUtils {

    /**
     * 从校验结果中抽取第一个错误的描述内容
     *
     * @param result 校验结果
     * @return 原因描述集合中的第一个
     */
    public static String wrapErrorFirst(BindingResult result) {
        List<String> errors = wrapErrorList(result);
        return CollectionUtils.isNotEmpty(errors) ? errors.get(0) : StringUtils.EMPTY;
    }

    /**
     * 从校验结果中抽取所有的校验不通过的描述原因
     *
     * @param result 校验结果
     * @return 原因描述集合
     */
    public static List<String> wrapErrorList(BindingResult result) {
        Map<String, String> map = wrapErrorMap(result);
        if (MapUtils.isEmpty(map)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(map.values());
    }

    /**
     * 从校验结果集中抽取参数以及说明
     *
     * @param result 校验结果集合
     * @return 属性与校验结果映射
     */
    public static Map<String, String> wrapErrorMap(BindingResult result) {
        if (!result.hasErrors()) {
            return Maps.newHashMap();
        }
        List<FieldError> list = result.getFieldErrors();
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map<String, String> map = Maps.newHashMap();
        list.forEach(li -> {
            map.put(li.getField(), li.getDefaultMessage());
        });
        return map;
    }

    public static String getExceptionName(Throwable e) {
        return StringUtils.getExceptionName(e);
    }
}
