package com.spring.boxes.dollar;


import org.apache.commons.lang3.math.NumberUtils;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AssetUtils {

    public static void isTrue(boolean condition, String message) {
        if (condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object o, String message) {
        if (Objects.isNull(o)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNullOrZero(Integer n, String message) {
        if (n == null || n == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNullOrZero(BigDecimal n, String message) {
        if (n == null || n.compareTo(BigDecimal.ZERO) == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNullOrZero(Long n, String message) {
        if (n == null || n == 0L) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void sholdDigits(String str, String message) {
        if(!NumberUtils.isDigits(str)){
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Collection collection, String message) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notBlank(String str, String message) {
        if (StringUtils.isBlank(str)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmail(String email) {
        String check = "^([a-zA-Z0-9]+[-_.]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[-_.]?)*[a-zA-Z0-9]+\\.[a-zA-Z]{2,6}$";
        Pattern regex = Pattern.compile(check);
        Matcher matcher = regex.matcher(email);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("请输入正确的邮箱");
        }
    }

    public static void notMobile(String mobile) {
        String check = "^1[3-9]\\d{9}$";
        Pattern regex = Pattern.compile(check);
        Matcher matcher = regex.matcher(mobile);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("请输入正确的手机号");
        }
    }

    public static void notIDNumber(String IDNumber) {
        // 18位 正则表达式
        String id_18 = "^[1-9][0-9]{5}(18|19|20)[0-9]{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)[0-9]{3}([0-9]|(X|x))";
        // 15位 正则表达式
        String id_15 = "^[1-9][0-9]{5}[0-9]{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)[0-9]{2}[0-9]";
        //或者关系校验
        String check = "(" + id_18 + ")" + "|" + "(" + id_15 + ")";
        Pattern regex = Pattern.compile(check);
        Matcher matcher = regex.matcher(IDNumber);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("请输入正确的身份证号");
        }
    }


}
