package com.spring.boxes.dollar;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.spring.boxes.dollar.support.MoreStream;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.reflections.ReflectionUtils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;

import static org.reflections.ReflectionUtils.withName;

@Slf4j
public class BeanUtils {

    public static void copyProperties(Object source, Object target) {
        BeanUtil.copyProperties(source, target, CopyOptions.create().setIgnoreNullValue(true).setIgnoreCase(true));
    }

    @SuppressWarnings("unchecked")
    public static void setPropertyVal(Object entity, String propertyName, Object propertyVal) {
        if (Objects.isNull(entity) || Objects.isNull(propertyName) || Objects.isNull(propertyVal)) {
            return;
        }
        try {
            Set<Field> fields = ReflectionUtils.getFields(entity.getClass(), withName(propertyName));
            if (CollectionUtils.isEmpty(fields)) {
                return;
            }
            Field field = MoreStream.getFirst(new ArrayList<>(fields));
            if (Objects.isNull(field)) {
                return;
            }
            field.setAccessible(true);
            field.set(entity, propertyVal);
        } catch (IllegalAccessException e) {
            log.error(e.getLocalizedMessage(), e);
        }
    }

    @SuppressWarnings("unchecked")
    public static Object getPropertyVal(Object entity, String propertyName) {
        if (Objects.isNull(entity) || Objects.isNull(propertyName)) {
            return null;
        }
        try {
            Set<Field> fields = ReflectionUtils.getFields(entity.getClass(), withName(propertyName));
            if (CollectionUtils.isEmpty(fields)) {
                return null;
            }
            Field field = MoreStream.getFirst(new ArrayList<>(fields));
            if (Objects.isNull(field)) {
                return null;
            }
            field.setAccessible(true);
            return field.get(entity);
        } catch (IllegalAccessException e) {
            log.error(e.getLocalizedMessage(), e);
        }
        return null;
    }
}
