package com.spring.boxes.dollar;

import static java.util.stream.Collectors.toMap;

import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;

public class EnumUtils {

    /**
     * 构建枚举字段 枚举对象的Map，构建出的Map可以用于后续根据字段值获取枚举对象。
     * EnumsUtils.buildFieldToEnumMap(Type.class, Type::getValue);
     * @param enumClass   枚举类
     * @param fieldMapper 字段映射函数
     * @return 字段值 枚举对象的Map
     */
    public static <T, E extends Enum<E>> Map<T, E> buildFieldToEnumMap(Class<E> enumClass, Function<E, T> fieldMapper) {
        return EnumSet.allOf(enumClass).stream().collect(toMap(fieldMapper, Function.identity()));
    }
}


