package com.spring.boxes.dollar;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.joda.time.DateTime;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;

@Slf4j
@UtilityClass
public class FileUtils extends org.apache.commons.io.FileUtils {


    public static boolean checkFileSize(MultipartFile file, int size, String unit) {
        if (file.isEmpty() || size == 0 || org.apache.commons.lang3.StringUtils.isEmpty(unit)) {
            return false;
        }
        long len = file.getSize();
        double fileSize = 0;
        if ("B".equals(unit.toUpperCase())) {
            fileSize = (double) len;
        } else if ("K".equals(unit.toUpperCase())) {
            fileSize = (double) len / 1024;
        } else if ("M".equals(unit.toUpperCase())) {
            fileSize = (double) len / 1048576;
        } else if ("G".equals(unit.toUpperCase())) {
            fileSize = (double) len / 1073741824;
        }
        if (fileSize > size) {
            return false;
        }
        return true;
    }

    public static String getEncodeFilename(String fileName) {
        return new String(fileName.getBytes(Charset.forName("ISO8859-1")), StandardCharsets.UTF_8);
    }

    public static String getOriginalFilename(MultipartFile file) {
        return Optional.ofNullable(file.getOriginalFilename()).orElse("");
    }

    public static String getOriginalFilename(File file) {
        return Optional.of(file.getName()).orElse("");
    }

    // Md5文件名
    public static String digestRename(String originName) {
        if (StringUtils.isBlank(originName)) {
            return StringUtils.EMPTY;
        }
        String newName = DigestUtils.md5Hex(originName) + getTimeMillisTail(5);
        return String.format("%s.%s", newName, FilenameUtils.getExtension(originName)).toLowerCase();
    }

    public static String snowRename(String originName) {
        if (StringUtils.isBlank(originName)) {
            return StringUtils.EMPTY;
        }
        String newName = IdWorker.getIdStr() + getTimeMillisTail(5);
        return String.format("%s.%s", newName, FilenameUtils.getExtension(originName)).toLowerCase();
    }

    public static String uuidRename(String originName) {
        if (StringUtils.isBlank(originName)) {
            return StringUtils.EMPTY;
        }
        return UUID.randomUUID() + "." + FilenameUtils.getExtension(originName).toLowerCase();
    }

    public static void download(String urlAddr, String downLoadPath) {
        if (StringUtils.isBlank(urlAddr)) {
            return;
        }
        try {
            org.apache.commons.io.FileUtils.copyURLToFile(new URL(urlAddr), new File(downLoadPath + "/" + digestRename(urlAddr)));
        } catch (IOException e) {
            log.error(e.getLocalizedMessage(), e);
        }
    }

    // 获取存储路径
    public static String getStorePath(int year, int month, int day, String storeName) {
        return getStorePath(null, year, month, day, storeName);
    }

    // 获取存储路径
    public static String getStorePath(DateTime dateTime, String storeName) {
        return getStorePath(null, dateTime, storeName);
    }

    // 获取存储路径
    public static String getStorePath(String rootPath, DateTime dateTime, String storeName) {
        String savedPath = StringUtils.isBlank(rootPath) ? DEFAULT_PATH : StringUtils.trim(rootPath);
        return String.format("%s/%s-%s-%s/%s", savedPath, dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), storeName);
    }

    // 获取存储路径
    public static String getStorePath(String rootPath, int year, int month, int day, String storeName) {
        String savedPath = StringUtils.isBlank(rootPath) ? DEFAULT_PATH : StringUtils.trim(rootPath);
        return String.format("%s/%s-%s-%s/%s", savedPath, year, month, day, storeName);
    }

    public static String getTimeMillisTail(int size){
        return String.valueOf(System.currentTimeMillis()).substring(13 - size, 13);
    }

    public static final String DEFAULT_PATH = "default";

}
